--This is written to batch inject container spawn rules for clothing and other items.
--Written by GanydeBielovzki for the Frockin' Splendor franchise and spin-offs.
--To copy,  modify or otherwise use this code the original creator must be credited.

require 'Items/ProceduralDistributions'

local function BatchRuleInjection(container, ...)
    for i = 1, select('#', ...), 2 do
        local item, weight = select(i, ...)
        table.insert(ProceduralDistributions.list[container].items, item)
        table.insert(ProceduralDistributions.list[container].items, weight)
    end
end

--Lootbox Injection
BatchRuleInjection("BedroomDresser","Bag_FrockinSplendor5_ToyBox", 0.25)
BatchRuleInjection("WardrobeGeneric","Bag_FrockinSplendor5_ToyBox", 0.25)
BatchRuleInjection("CrateClothesRandom","Bag_FrockinSplendor5_ToyBox", 0.5)
BatchRuleInjection("StripClubDressers","Bag_FrockinSplendor5_ToyBox", 10)

-- Batch Injection:
BatchRuleInjection("ClothingStoresShirts",
    "Base.Cotton_Blouse", 0.4,
    "Base.Cotton_Blouse_V", 0.8,
    "Base.Cotton_Blouse_V_Cropped", 0.4,
    "Base.Cotton_Blouse_V_Cropped_Tiny", 0.4,
    "Base.Lumberjack_Shirt_10", 4.7,
    "Base.Lumberjack_Cropped_Shirt_10", 30.4,
    "Base.Lumberjack_Sleeveless_Shirt_10", 30.4,
    "Base.Denim_Shirt_10", 0.8,
    "Base.Denim_Sleeveless_Shirt_10", 0.7
)

BatchRuleInjection("ClothingStoresWoman",
    "Base.Cotton_Blouse", 1.0,
    "Base.Cotton_Blouse_V", 1.0,
    "Base.Cotton_Blouse_V_Cropped", 0.8,
    "Base.Cotton_Blouse_V_Cropped_Tiny", 0.7,
    "Base.Denim_Bandeau", 0.4,
    "Base.Denim_Bandeau_Tiny", 0.4,
    "Base.Denim_Top", 0.8,
    "Base.Denim_CropTop", 0.7,
    "Base.TannedLeather_Top", 0.7,
    "Base.TannedLeather_TopSkimpy", 0.4,
    "Base.TannedLeather_CropTop", 0.7,
    "Base.TannedLeather_Bandeau", 0.4,
    "Base.TannedLeather_Bandeau_Tiny", 0.4,
    "Base.TannedLeather_Corset_OuterLayer", 0.8,
    "Base.TannedLeather_Corset_UB_OuterLayer", 0.7,
    "Base.TannedLeather_Corset_Strap_OuterLa", 0.4,
    "Base.TannedLeather_Corset_UB_Strap_Oute", 0.4,
    "Base.TannedLeather_WaistCoat", 0.7
)

BatchRuleInjection("ClothingStoresJeans",
    "Base.Mesh_Denim_Pants", 0.8,
    "Base.Mesh_Denim_PantsFlared", 0.7,
    "Base.Mesh_Denim_PantsChaps", 0.4,
    "Base.Denim_Shorts_J", 0.4
)

BatchRuleInjection("ClothingStoresJackets",
    "Base.Denim_Jacket_Cropped", 2.7,
    "Base.Denim_Jacket_O", 2.9,
    "Base.Denim_JacketReinforced_O", 2.8,
    "Base.Denim_JacketShort_O", 2.8,
    "Base.Denim_VestJacket_O",0.75,
    "Base.Denim_VestJacketCropped_O", 2,
    "Base.Denim_VestJacketShort_O", 2.7,
    "Base.Denim_Overshirt_O", 2.8,
    "Base.FurCoat_Fur", 2,
    "Base.FurJacketShort_O", 2,
	"Base.Denim_Jacket_Cropped", 2,
	"Base.Denim_Jacket", 2,
	"Base.Denim_Jacket_O", 2,
	"Base.Denim_JacketReinforced", 2,
	"Base.Denim_JacketReinforced_O", 2,
	"Base.Denim_JacketShort", 2,
	"Base.Denim_JacketShort_O", 2,
	"Base.Denim_VestJacket", 2,
	"Base.Denim_VestJacket_O", 2,
	"Base.Denim_VestJacketCropped", 2,
	"Base.Denim_VestJacketCropped_O", 2,
	"Base.Denim_VestJacketShort", 2,
	"Base.Denim_VestJacketShort_O", 2,
	"Base.Denim_LongCoat", 2,
	"Base.Denim_LongCoat_O", 2,
	"Base.Denim_LongCoatShort", 2,
	"Base.Denim_LongCoatShort_O", 2,
	"Base.Denim_LongCoatShort_Reinforced", 2,
	"Base.Denim_LongCoatShort_Reinforced_O", 2,
	"Base.Denim_LongCoatShortSleeveless", 2,
	"Base.Denim_LongCoatShortSleeveless_O", 2,
	"Base.Denim_TrenchCoat_Long_O", 2,
	"Base.Denim_TrenchCoat_Short_O", 2,
	"Base.TannedLeather_Jacket_Cropped", 2,
	"Base.TannedLeather_LongestCoat", 2,
	"Base.TannedLeather_LongestCoat_O", 2,
	"Base.TannedLeather_LongerCoat", 2,
	"Base.TannedLeather_LongerCoat_O", 2,
	"Base.TannedLeather_LongCoat", 2,
	"Base.TannedLeather_LongCoat_O", 2,
	"Base.TannedLeather_Jacket", 2,
	"Base.TannedLeather_Jacket_O", 2,
	"Base.TannedLeather_Jacket_MidLength", 2,
	"Base.TannedLeather_Jacket_MidLength_O", 2,
	"Base.TannedLeather_TrenchCoat_Long_O", 2,
	"Base.TannedLeather_TrenchCoat_Short_O", 2,
	"Base.TannedLeather_LongestCoat_Winter", 2,
	"Base.TannedLeather_LongestCoat_Winter_O", 2,
	"Base.TannedLeather_LongerCoat_Winter", 2,
	"Base.TannedLeather_LongerCoat_Winter_O", 2,
	"Base.Cotton_LongestCoat_VintageMil", 2,	
	"Base.Cotton_LongestCoat_VintageMil_O", 2.5
)

BatchRuleInjection("ClothingStoresJacketsLeather",
    "Base.Denim_JacketReinforced_O", 0.4,
    "Base.Denim_LongCoatShort_Reinforced_O", 0.4,
    "Base.TannedLeather_Jacket_Cropped", 0.8,
    "Base.TannedLeather_LongestCoat_O", 0.7,
    "Base.TannedLeather_LongerCoat_O", 0.8,
    "Base.TannedLeather_LongCoat_O", 0.9,
    "Base.TannedLeather_Jacket_O", 1.0,
    "Base.TannedLeather_Jacket_MidLength_O", 0.9,
    "Base.TannedLeather_TrenchCoat_Long_O", 0.8,
    "Base.TannedLeather_TrenchCoat_Short_O", 0.9,
    "Base.TannedLeather_LongestCoat_Winter_O", 0.4,
    "Base.TannedLeather_LongerCoat_Winter_O", 0.7,
	"Base.Denim_Jacket_Cropped", 0.4,
	"Base.Denim_Jacket", 0.4,
	"Base.Denim_Jacket_O", 0.4,
	"Base.Denim_JacketReinforced", 0.4,
	"Base.Denim_JacketReinforced_O", 0.4,
	"Base.Denim_JacketShort", 0.4,
	"Base.Denim_JacketShort_O", 0.4,
	"Base.Denim_VestJacket", 0.4,
	"Base.Denim_VestJacket_O", 0.4,
	"Base.Denim_VestJacketCropped", 0.4,
	"Base.Denim_VestJacketCropped_O", 0.4,
	"Base.Denim_VestJacketShort", 0.4,
	"Base.Denim_VestJacketShort_O", 0.4,
	"Base.Denim_LongCoat", 0.4,
	"Base.Denim_LongCoat_O", 0.4,
	"Base.Denim_LongCoatShort", 0.4,
	"Base.Denim_LongCoatShort_O", 0.4,
	"Base.Denim_LongCoatShort_Reinforced", 0.4,
	"Base.Denim_LongCoatShort_Reinforced_O", 0.4,
	"Base.Denim_LongCoatShortSleeveless", 0.4,
	"Base.Denim_LongCoatShortSleeveless_O", 0.4,
	"Base.Denim_TrenchCoat_Long_O", 0.4,
	"Base.Denim_TrenchCoat_Short_O", 0.4,
	"Base.TannedLeather_Jacket_Cropped", 0.4,
	"Base.TannedLeather_LongestCoat", 0.4,
	"Base.TannedLeather_LongestCoat_O", 0.4,
	"Base.TannedLeather_LongerCoat", 0.4,
	"Base.TannedLeather_LongerCoat_O", 0.4,
	"Base.TannedLeather_LongCoat", 0.4,
	"Base.TannedLeather_LongCoat_O", 0.4,
	"Base.TannedLeather_Jacket", 0.4,
	"Base.TannedLeather_Jacket_O", 0.4,
	"Base.TannedLeather_Jacket_MidLength", 0.4,
	"Base.TannedLeather_Jacket_MidLength_O", 0.4,
	"Base.TannedLeather_TrenchCoat_Long_O", 0.4,
	"Base.TannedLeather_TrenchCoat_Short_O", 0.4,
	"Base.TannedLeather_LongestCoat_Winter", 0.4,
	"Base.TannedLeather_LongestCoat_Winter_O", 0.4,
	"Base.TannedLeather_LongerCoat_Winter", 0.4,
	"Base.TannedLeather_LongerCoat_Winter_O", 0.4,
	"Base.Cotton_LongestCoat_VintageMil", 0.4,	
	"Base.Cotton_LongestCoat_VintageMil_O", 0.4
)

BatchRuleInjection("ClothingStoresJumpers",
    "Base.Denim_LongCoat_O", 0.4,
    "Base.Denim_LongCoatShort_O", 0.7,
    "Base.Denim_TrenchCoat_Long_O", 0.8,
    "Base.Denim_TrenchCoat_Short_O", 0.9
)

BatchRuleInjection("ClothingStoresSummer",
    "Base.Mesh_Denim_Shorts", 0.9,
    "Base.Mesh_Denim_ShortShorts", 0.8,
    "Base.Mesh_Denim_ShorterShorts", 0.7,
    "Base.Skin_Denim_Shorts", 0.4,
    "Base.Mesh_Denim_LongShorts", 0.8,
    "Base.Denim_Shorts_J", 0.7,
    "Base.TMesh_TannedLeather_Shorts", 0.8,
    "Base.TMesh_TannedLeather_ShortShorts", 0.7,
    "Base.TMesh_TannedLeather_ShorterShorts", 0.4,
    "Base.TannedLeather_Shorts_J", 0.7
)

BatchRuleInjection("ClothingStoresSport",
    "Base.Mesh_Denim_Shorts", 0.7,
    "Base.Mesh_Denim_ShortShorts", 0.4,
    "Base.FF_Shoe_Trainers", 1.0,
    "Base.FF_Shoe_TrainersBlack", 0.9,
    "Base.FF_Shoe_TrainersWhite", 0.9,
    "Base.FF_Shoe_Common", 0.8,
    "Base.TannedLeather_Leotard", 0.7,
    "Base.TannedLeather_Leotard_MC", 0.4,
    "Base.TannedLeather_Leotard_HC", 0.4,
    "Base.TannedLeather_LeotardUB", 0.4,
    "Base.TannedLeather_LeotardUB_MC", 0.4,
    "Base.TannedLeather_LeotardUB_HC", 0.4
)

BatchRuleInjection("ClothingStoresDress",
    "Base.Denim_Skirt_Short", 0.8,
    "Base.Denim_Skirt_Short_LW", 0.7,
    "Base.Denim_Skirt_Longer", 0.9,
    "Base.Denim_Skirt_Long", 1.0,
    "Base.Denim_Skirt_Mesh_HW", 0.4,
    "Base.Denim_Skirt_Mesh_LW", 0.4,
    "Base.Denim_SkirtPleated", 0.8,
    "Base.Denim_SkirtPleated_Frilled", 0.7,
    "Base.Mesh_Denim_Skirt_Longer", 0.4,
    "Base.TannedLeather_Skirt_Mesh_HW", 0.4,
    "Base.TannedLeather_Skirt_Mesh_LW", 0.4,
    "Base.TannedLeather_Skirt_Mesh_LerW", 0.7,
    "Base.TannedLeather_Skirt_MeshFrilled_HW", 0.4,
    "Base.TannedLeather_Skirt_MeshFrilled_LW", 0.4,
    "Base.TannedLeather_Skirt_MeshFrilled_LerW", 0.4,
	"Base.TannedLeather_SkirtMicro_MeshFrilled", 0.4,
    "Base.TannedLeather_SkirtMicro_Mesh", 0.4,
    "Base.TannedLeather_SkirtMicro_MeshFrill", 0.4,
    "Base.TannedLeather_Long_Skirt", 0.8,
    "Base.TannedLeather_Skirt_Mid", 0.9,
    "Base.TannedLeather_Skirt_Short", 1.0,
    "Base.TannedLeather_Skirt_Shorter", 0.7
)

BatchRuleInjection("ClothingStorageWinter",
    "Base.FurCoat_Fur", 1.8,
    "Base.FurJacketShort_O", 1.9,
    "Base.TannedLeather_LongestCoat_Winter_O", 1.8,
    "Base.TannedLeather_LongerCoat_Winter_O", 1.9,
    "Base.FF_Boots_UGG", 1.7,
    "Base.FF_Boots_UGG_Thighhigh", 10.4,
    "Base.FF_Boots_UGG_Kneehigh", 1.8,
    "Base.FF_Boots_UGG_DwarfHeel", 10.4,
    "Base.FF_Boots_UGG_Heel", 10.4,
    "Base.FF_Boots_UGG_ThighhighHeel", 10.4,
    "Base.FF_Boots_UGG_KneehighHeel", 10.4,
	"Base.Denim_Jacket_Cropped", 10.4,
	"Base.Denim_Jacket", 10.4,
	"Base.Denim_Jacket_O", 10.4,
	"Base.Denim_JacketReinforced", 10.4,
	"Base.Denim_JacketReinforced_O", 10.4,
	"Base.Denim_JacketShort", 10.4,
	"Base.Denim_JacketShort_O", 10.4,
	"Base.Denim_VestJacket", 10.4,
	"Base.Denim_VestJacket_O", 10.4,
	"Base.Denim_VestJacketCropped", 10.4,
	"Base.Denim_VestJacketCropped_O", 10.4,
	"Base.Denim_VestJacketShort", 10.4,
	"Base.Denim_VestJacketShort_O", 10.4,
	"Base.Denim_LongCoat", 10.4,
	"Base.Denim_LongCoat_O", 10.4,
	"Base.Denim_LongCoatShort", 10.4,
	"Base.Denim_LongCoatShort_O", 10.4,
	"Base.Denim_LongCoatShort_Reinforced", 10.4,
	"Base.Denim_LongCoatShort_Reinforced_O", 10.4,
	"Base.Denim_LongCoatShortSleeveless", 10.4,
	"Base.Denim_LongCoatShortSleeveless_O", 10.4,
	"Base.Denim_TrenchCoat_Long_O", 10.4,
	"Base.Denim_TrenchCoat_Short_O", 10.4,
	"Base.TannedLeather_Jacket_Cropped", 10.4,
	"Base.TannedLeather_LongestCoat", 10.4,
	"Base.TannedLeather_LongestCoat_O", 10.4,
	"Base.TannedLeather_LongerCoat", 10.4,
	"Base.TannedLeather_LongerCoat_O", 10.4,
	"Base.TannedLeather_LongCoat", 10.4,
	"Base.TannedLeather_LongCoat_O", 10.4,
	"Base.TannedLeather_Jacket", 10.4,
	"Base.TannedLeather_Jacket_O", 10.4,
	"Base.TannedLeather_Jacket_MidLength", 10.4,
	"Base.TannedLeather_Jacket_MidLength_O", 10.4,
	"Base.TannedLeather_TrenchCoat_Long_O", 10.4,
	"Base.TannedLeather_TrenchCoat_Short_O", 10.4,
	"Base.TannedLeather_LongestCoat_Winter", 10.4,
	"Base.TannedLeather_LongestCoat_Winter_O", 10.4,
	"Base.TannedLeather_LongerCoat_Winter", 10.4,
	"Base.TannedLeather_LongerCoat_Winter_O", 10.4,
	"Base.Cotton_LongestCoat_VintageMil", 10.4,	
	"Base.Cotton_LongestCoat_VintageMil_O", 1.5
)

BatchRuleInjection("ClothingStoresShoes",
    "Base.FF_Boots_HF_New", 2,
    "Base.FF_Boots_HF_New_Longest", 2,
    "Base.FF_Boots_HF_New_Longer", 2,
    "Base.FF_Boots_HF_New_Long", 2,
    "Base.FF_Boots_Leather", 2,
    "Base.FF_Boots_Leather_Short", 2,
    "Base.FF_Boots_Cowboy", 2,
    "Base.FF_Boots_Cowboy_Plain", 2,
    "Base.FF_Shoe_Boots_Ankle", 2,
    "Base.FF_Shoe_Boots_Ankle_Steel", 2,
    "Base.FF_Boots_Common", 2,
    "Base.FF_Boots_Platform_Thighhigh", 2,
    "Base.FF_Boots_Platform_Kneehigher", 2,
    "Base.FF_Boots_Platform_Kneehigh", 2,
    "Base.FF_Boots_Platform_Ankle", 2,
    "Base.FF_Boots_Platform_AnkleLow", 2,
    "Base.FF_Boots_Pointy_AnkleLow", 2,
    "Base.FF_Boots_Pointy_Ankle", 2,
    "Base.FF_Boots_Pointy_Kneehigh", 2,
	"Base.FF_Boots_HF_New", 2,
	"Base.FF_Boots_HF_New_Longest", 2,
	"Base.FF_Boots_HF_New_Longer", 2,
	"Base.FF_Boots_HF_New_Long", 2,
	"Base.FF_Shoe_Boots_Ankle_Platform", 2,
	"Base.FF_Boots_HighHeels", 2,
	"Base.FF_Shoe_Women", 2,
	"Base.FF_Shoe_Women_Platform", 2,
	"Base.FF_Shoe_Women_2", 2,
	"Base.FF_Shoe_Moccasin", 2,
	"Base.FF_Boots_UGG_DwarfHeel", 2,
	"Base.FF_Boots_UGG_Heel", 2,
	"Base.FF_Boots_UGG_ThighhighHeel", 2,
	"Base.FF_Boots_UGG_KneehighHeel", 2,
	"Base.FF_Boots_UGG", 2,
	"Base.FF_Boots_UGG_Thighhigh", 2,
	"Base.FF_Boots_UGG_Kneehigh", 2,
	"Base.FF_Boots_Leather", 2,
	"Base.FF_Boots_Leather_Short", 2,
	"Base.FF_Boots_Cowboy", 2,
	"Base.FF_Boots_Cowboy_Plain", 2,
	"Base.FF_Shoe_Boots_Ankle", 2,
	"Base.FF_Shoe_Boots_Ankle_Steel", 2,
	"Base.FF_Boots_Common", 2,
	"Base.FF_Shoe_Common", 2,
	"Base.FF_Shoe_Trainers", 2,
	"Base.FF_Shoe_TrainersBlack", 2,
	"Base.FF_Shoe_TrainersWhite", 2,
	"Base.FF_Boots_Platform_Thighhigh", 2,
	"Base.FF_Boots_Platform_Kneehigher", 2,
	"Base.FF_Boots_Platform_Kneehigh", 2,
	"Base.FF_Boots_Platform_Ankle", 2,
	"Base.FF_Boots_Platform_AnkleLow", 2,
	"Base.FF_Boots_PlatformPunk_Thighhigh", 2,
	"Base.FF_Boots_PlatformPunk_Kneehigher", 2,
	"Base.FF_Boots_PlatformPunk_Kneehigh", 2,
	"Base.FF_Boots_Pointy_AnkleLow", 2,
	"Base.FF_Boots_Pointy_Ankle", 2,
	"Base.FF_Boots_Pointy_Kneehigh", 2,
	"Base.FF_Boots_PointySkull_AnkleLow", 2,
	"Base.FF_Boots_PointySkull_Kneehigh", 2,
	"Base.FF_BootsRE_Leather_DwarfHeel", 2,
	"Base.FF_BootsRE_Leather_Heel", 2,
	"Base.FF_BootsRE_Leather_ThighhighHeel", 2,
	"Base.FF_BootsRE_Leather_KneehighHeel", 2,
	"Base.FF_Boots_Military_Thighhigh", 2,
	"Base.FF_Boots_Military_Kneehigher", 2,
	"Base.FF_Boots_Military_Kneehigh", 2,
	"Base.FF_Boots_Military_Ankle", 2
)

BatchRuleInjection("ClosetShelfGeneric",
    "Base.FF_Boots_HF_New", 0.20,
    "Base.FF_Boots_HF_New_Longest", 0.20,
    "Base.FF_Boots_HF_New_Longer", 0.20,
    "Base.FF_Boots_HF_New_Long", 0.20,
    "Base.FF_Boots_Leather", 0.20,
    "Base.FF_Boots_Leather_Short", 0.20,
    "Base.FF_Boots_Cowboy", 0.20,
    "Base.FF_Boots_Cowboy_Plain", 0.20,
    "Base.FF_Shoe_Boots_Ankle", 0.20,
    "Base.FF_Shoe_Boots_Ankle_Steel", 0.20,
    "Base.FF_Boots_Common", 0.20,
    "Base.FF_Boots_Platform_Thighhigh", 0.20,
    "Base.FF_Boots_Platform_Kneehigher", 0.20,
    "Base.FF_Boots_Platform_Kneehigh", 0.20,
    "Base.FF_Boots_Platform_Ankle", 0.20,
    "Base.FF_Boots_Platform_AnkleLow", 0.20,
    "Base.FF_Boots_Pointy_AnkleLow", 0.20,
    "Base.FF_Boots_Pointy_Ankle", 0.20,
    "Base.FF_Boots_Pointy_Kneehigh", 0.20,
	"Base.FF_Boots_HF_New", 0.20,
	"Base.FF_Boots_HF_New_Longest", 0.20,
	"Base.FF_Boots_HF_New_Longer", 0.20,
	"Base.FF_Boots_HF_New_Long", 0.20,
	"Base.FF_Shoe_Boots_Ankle_Platform", 0.20,
	"Base.FF_Boots_HighHeels", 0.20,
	"Base.FF_Shoe_Women", 0.20,
	"Base.FF_Shoe_Women_Platform", 0.20,
	"Base.FF_Shoe_Women_2", 0.20,
	"Base.FF_Shoe_Moccasin", 0.20,
	"Base.FF_Boots_UGG_DwarfHeel", 0.20,
	"Base.FF_Boots_UGG_Heel", 0.20,
	"Base.FF_Boots_UGG_ThighhighHeel", 0.20,
	"Base.FF_Boots_UGG_KneehighHeel", 0.20,
	"Base.FF_Boots_UGG", 0.20,
	"Base.FF_Boots_UGG_Thighhigh", 0.20,
	"Base.FF_Boots_UGG_Kneehigh", 0.20,
	"Base.FF_Boots_Leather", 0.20,
	"Base.FF_Boots_Leather_Short", 0.20,
	"Base.FF_Boots_Cowboy", 0.20,
	"Base.FF_Boots_Cowboy_Plain", 0.20,
	"Base.FF_Shoe_Boots_Ankle", 0.20,
	"Base.FF_Shoe_Boots_Ankle_Steel", 0.20,
	"Base.FF_Boots_Common", 0.20,
	"Base.FF_Shoe_Common", 0.20,
	"Base.FF_Shoe_Trainers", 0.20,
	"Base.FF_Shoe_TrainersBlack", 0.20,
	"Base.FF_Shoe_TrainersWhite", 0.20,
	"Base.FF_Boots_Platform_Thighhigh", 0.20,
	"Base.FF_Boots_Platform_Kneehigher", 0.20,
	"Base.FF_Boots_Platform_Kneehigh", 0.20,
	"Base.FF_Boots_Platform_Ankle", 0.20,
	"Base.FF_Boots_Platform_AnkleLow", 0.20,
	"Base.FF_Boots_PlatformPunk_Thighhigh", 0.20,
	"Base.FF_Boots_PlatformPunk_Kneehigher", 0.20,
	"Base.FF_Boots_PlatformPunk_Kneehigh", 0.20,
	"Base.FF_Boots_Pointy_AnkleLow", 0.20,
	"Base.FF_Boots_Pointy_Ankle", 0.20,
	"Base.FF_Boots_Pointy_Kneehigh", 0.20,
	"Base.FF_Boots_PointySkull_AnkleLow", 0.20,
	"Base.FF_Boots_PointySkull_Kneehigh", 0.20,
	"Base.FF_BootsRE_Leather_DwarfHeel", 0.20,
	"Base.FF_BootsRE_Leather_Heel", 0.20,
	"Base.FF_BootsRE_Leather_ThighhighHeel", 0.20,
	"Base.FF_BootsRE_Leather_KneehighHeel", 0.20,
	"Base.FF_Boots_Military_Thighhigh", 0.20,
	"Base.FF_Boots_Military_Kneehigher", 0.20,
	"Base.FF_Boots_Military_Kneehigh", 0.20,
	"Base.FF_Boots_Military_Ankle", 1
)

BatchRuleInjection("ClothingStoresShoesLeather",
    "Base.FF_Boots_HF_New", 2,
    "Base.FF_Boots_HF_New_Longest", 2,
    "Base.FF_Boots_HF_New_Longer", 2,
    "Base.FF_Boots_HF_New_Long", 2,
    "Base.FF_Boots_Leather", 2,
    "Base.FF_Boots_Leather_Short", 2,
    "Base.FF_Boots_Cowboy", 2,
    "Base.FF_Boots_Cowboy_Plain", 2,
    "Base.FF_Shoe_Boots_Ankle", 2,
    "Base.FF_Shoe_Boots_Ankle_Steel", 2,
    "Base.FF_Boots_Common", 2,
    "Base.FF_Boots_Platform_Thighhigh", 2,
    "Base.FF_Boots_Platform_Kneehigher", 2,
    "Base.FF_Boots_Platform_Kneehigh", 2,
    "Base.FF_Boots_Platform_Ankle", 2,
    "Base.FF_Boots_Platform_AnkleLow", 2,
    "Base.FF_Boots_Pointy_AnkleLow", 2,
    "Base.FF_Boots_Pointy_Ankle", 2,
    "Base.FF_Boots_Pointy_Kneehigh", 2,
	"Base.FF_Boots_HF_New", 2,
	"Base.FF_Boots_HF_New_Longest", 2,
	"Base.FF_Boots_HF_New_Longer", 2,
	"Base.FF_Boots_HF_New_Long", 2,
	"Base.FF_Shoe_Boots_Ankle_Platform", 2,
	"Base.FF_Boots_HighHeels", 2,
	"Base.FF_Shoe_Women", 2,
	"Base.FF_Shoe_Women_Platform", 2,
	"Base.FF_Shoe_Women_2", 2,
	"Base.FF_Shoe_Moccasin", 2,
	"Base.FF_Boots_UGG_DwarfHeel", 2,
	"Base.FF_Boots_UGG_Heel", 2,
	"Base.FF_Boots_UGG_ThighhighHeel", 2,
	"Base.FF_Boots_UGG_KneehighHeel", 2,
	"Base.FF_Boots_UGG", 2,
	"Base.FF_Boots_UGG_Thighhigh", 2,
	"Base.FF_Boots_UGG_Kneehigh", 2,
	"Base.FF_Boots_Leather", 2,
	"Base.FF_Boots_Leather_Short", 2,
	"Base.FF_Boots_Cowboy", 2,
	"Base.FF_Boots_Cowboy_Plain", 2,
	"Base.FF_Shoe_Boots_Ankle", 2,
	"Base.FF_Shoe_Boots_Ankle_Steel", 2,
	"Base.FF_Boots_Common", 2,
	"Base.FF_Shoe_Common", 2,
	"Base.FF_Shoe_Trainers", 2,
	"Base.FF_Shoe_TrainersBlack", 2,
	"Base.FF_Shoe_TrainersWhite", 2,
	"Base.FF_Boots_Platform_Thighhigh", 2,
	"Base.FF_Boots_Platform_Kneehigher", 2,
	"Base.FF_Boots_Platform_Kneehigh", 2,
	"Base.FF_Boots_Platform_Ankle", 2,
	"Base.FF_Boots_Platform_AnkleLow", 2,
	"Base.FF_Boots_PlatformPunk_Thighhigh", 2,
	"Base.FF_Boots_PlatformPunk_Kneehigher", 2,
	"Base.FF_Boots_PlatformPunk_Kneehigh", 2,
	"Base.FF_Boots_Pointy_AnkleLow", 2,
	"Base.FF_Boots_Pointy_Ankle", 2,
	"Base.FF_Boots_Pointy_Kneehigh", 2,
	"Base.FF_Boots_PointySkull_AnkleLow", 2,
	"Base.FF_Boots_PointySkull_Kneehigh", 2,
	"Base.FF_BootsRE_Leather_DwarfHeel", 2,
	"Base.FF_BootsRE_Leather_Heel", 2,
	"Base.FF_BootsRE_Leather_ThighhighHeel", 2,
	"Base.FF_BootsRE_Leather_KneehighHeel", 2,
	"Base.FF_Boots_Military_Thighhigh", 2,
	"Base.FF_Boots_Military_Kneehigher", 2,
	"Base.FF_Boots_Military_Kneehigh", 2,
	"Base.FF_Boots_Military_Ankle", 2
)

BatchRuleInjection("ClothingStoresBoots",
    "Base.FF_Boots_HF_New", 2,
    "Base.FF_Boots_HF_New_Longest", 2,
    "Base.FF_Boots_HF_New_Longer", 2,
    "Base.FF_Boots_HF_New_Long", 2,
    "Base.FF_Boots_Leather", 2,
    "Base.FF_Boots_Leather_Short", 2,
    "Base.FF_Boots_Cowboy", 2,
    "Base.FF_Boots_Cowboy_Plain", 2,
    "Base.FF_Shoe_Boots_Ankle", 2,
    "Base.FF_Shoe_Boots_Ankle_Steel", 2,
    "Base.FF_Boots_Common", 2,
    "Base.FF_Boots_Platform_Thighhigh", 2,
    "Base.FF_Boots_Platform_Kneehigher", 2,
    "Base.FF_Boots_Platform_Kneehigh", 2,
    "Base.FF_Boots_Platform_Ankle", 2,
    "Base.FF_Boots_Platform_AnkleLow", 2,
    "Base.FF_Boots_Pointy_AnkleLow", 2,
    "Base.FF_Boots_Pointy_Ankle", 2,
    "Base.FF_Boots_Pointy_Kneehigh", 2,
	"Base.FF_Boots_HF_New", 2,
	"Base.FF_Boots_HF_New_Longest", 2,
	"Base.FF_Boots_HF_New_Longer", 2,
	"Base.FF_Boots_HF_New_Long", 2,
	"Base.FF_Shoe_Boots_Ankle_Platform", 2,
	"Base.FF_Boots_HighHeels", 2,
	"Base.FF_Shoe_Women", 2,
	"Base.FF_Shoe_Women_Platform", 2,
	"Base.FF_Shoe_Women_2", 2,
	"Base.FF_Shoe_Moccasin", 2,
	"Base.FF_Boots_UGG_DwarfHeel", 2,
	"Base.FF_Boots_UGG_Heel", 2,
	"Base.FF_Boots_UGG_ThighhighHeel", 2,
	"Base.FF_Boots_UGG_KneehighHeel", 2,
	"Base.FF_Boots_UGG", 2,
	"Base.FF_Boots_UGG_Thighhigh", 2,
	"Base.FF_Boots_UGG_Kneehigh", 2,
	"Base.FF_Boots_Leather", 2,
	"Base.FF_Boots_Leather_Short", 2,
	"Base.FF_Boots_Cowboy", 2,
	"Base.FF_Boots_Cowboy_Plain", 2,
	"Base.FF_Shoe_Boots_Ankle", 2,
	"Base.FF_Shoe_Boots_Ankle_Steel", 2,
	"Base.FF_Boots_Common", 2,
	"Base.FF_Shoe_Common", 2,
	"Base.FF_Shoe_Trainers", 2,
	"Base.FF_Shoe_TrainersBlack", 2,
	"Base.FF_Shoe_TrainersWhite", 2,
	"Base.FF_Boots_Platform_Thighhigh", 2,
	"Base.FF_Boots_Platform_Kneehigher", 2,
	"Base.FF_Boots_Platform_Kneehigh", 2,
	"Base.FF_Boots_Platform_Ankle", 2,
	"Base.FF_Boots_Platform_AnkleLow", 2,
	"Base.FF_Boots_PlatformPunk_Thighhigh", 2,
	"Base.FF_Boots_PlatformPunk_Kneehigher", 2,
	"Base.FF_Boots_PlatformPunk_Kneehigh", 2,
	"Base.FF_Boots_Pointy_AnkleLow", 2,
	"Base.FF_Boots_Pointy_Ankle", 2,
	"Base.FF_Boots_Pointy_Kneehigh", 2,
	"Base.FF_Boots_PointySkull_AnkleLow", 2,
	"Base.FF_Boots_PointySkull_Kneehigh", 2,
	"Base.FF_BootsRE_Leather_DwarfHeel", 2,
	"Base.FF_BootsRE_Leather_Heel", 2,
	"Base.FF_BootsRE_Leather_ThighhighHeel", 2,
	"Base.FF_BootsRE_Leather_KneehighHeel", 2,
	"Base.FF_Boots_Military_Thighhigh", 2,
	"Base.FF_Boots_Military_Kneehigher", 2,
	"Base.FF_Boots_Military_Kneehigh", 2,
	"Base.FF_Boots_Military_Ankle", 2
)

BatchRuleInjection("ClothingStoresPantsLeather",
    "Base.TMesh_TannedLeather_Pants", 0.9,
    "Base.TMesh_TannedLeather_LongShorts", 0.8,
    "Base.TSkin_TannedLeather_Pants", 0.7,
    "Base.TannedLeather_Shorts_J", 0.8
)

BatchRuleInjection("ClothingStoresHeadwear",
    "Base.Hat_Cowboy_Flat", 0.8
)

BatchRuleInjection("WildWestClothing",
    "Base.Belt_Cowboy", 3.0,
    "Base.BeltLarge", 3.0,
    "Base.Accessory_Wild_Rag", 3.0,
    "Base.Accessory_Wild_Rag_Bandana", 3.0,
	"Base.Accessory_Wild_Rag_Scarf", 3.0,
    "Base.Accessory_Tie_Bolo", 3.0,
    "Base.Accessory_Tie_Bolo_Star", 3.0,
    "Base.Accessory_Tie_Bolo_Sun", 3.0,
    "Base.Accessory_Tie_Bolo_Moon", 3.0,
    "Base.FF_Boots_Cowboy", 3.0,
    "Base.FF_Boots_Cowboy_Plain", 5.0,
    "Base.FF_Shoe_Moccasin", 3.0,
    "Base.Hat_Cowboy_Flat", 3.0,
	"Base.Denim_JacketReinforced_O", 3.0,
    "Base.Denim_LongCoatShort_Reinforced_O", 3.0,
    "Base.TannedLeather_Jacket_Cropped", 3.0,
    "Base.TannedLeather_LongestCoat_O", 3.0,
    "Base.TannedLeather_LongerCoat_O", 3.0,
    "Base.TannedLeather_LongCoat_O", 3.0,
    "Base.TannedLeather_Jacket_O", 3.0,
    "Base.TannedLeather_Jacket_MidLength_O", 3.0,
    "Base.TannedLeather_TrenchCoat_Long_O", 3.0,
    "Base.TannedLeather_TrenchCoat_Short_O", 3.0,
    "Base.TannedLeather_LongestCoat_Winter_O", 3.0,
    "Base.TannedLeather_LongerCoat_Winter_O", 3.0,
	"Base.Denim_Jacket_Cropped", 3.0,
    "Base.Denim_Jacket_O", 3.0,
    "Base.Denim_JacketReinforced_O", 3.0,
    "Base.Denim_JacketShort_O", 3.0,
    "Base.Denim_VestJacket_O", 3.0,
    "Base.Denim_VestJacketCropped_O", 3.0,
    "Base.Denim_VestJacketShort_O", 3.0,
    "Base.Denim_Overshirt_O", 3.0,
    "Base.FurCoat_Fur", 3.0,
    "Base.FurJacketShort_O", 3.0
)

BatchRuleInjection("ArmySurplusFootwear",
    "Base.FF_Boots_Military_Thighhigh", 0.8,
    "Base.FF_Boots_Military_Kneehigher", 0.9,
    "Base.FF_Boots_Military_Kneehigh", 1.0,
    "Base.FF_Boots_Military_Ankle", 0.9,
    "Base.FF_Boots_Common", 0.7,
    "Base.FF_Shoe_Common", 0.4
)

BatchRuleInjection("GunStoreBodyArmor",
    "Base.Armour_PouchStrap", 0.8,
    "Base.Armour_Faulds", 0.7,
    "Base.Armour_Faulds_Short", 0.8,
    "Base.Armour_ShoulderPad_R", 0.4,
    "Base.Armour_ShoulderPad_L", 0.4,
    "Base.Armour_Armguards_R", 0.7,
    "Base.Armour_Armguards_L", 0.7,
    "Base.Armour_ArmguardsLong_R", 0.4,
    "Base.Armour_ArmguardsLong_L", 0.4,
    "Base.TannedLeather_SleevesLeg_L", 0.4,
    "Base.TannedLeather_SleevesLeg_R", 0.4,
    "Base.TannedLeather_Sleeves_L", 0.7,
    "Base.TannedLeather_Sleeves_R", 0.7
)

BatchRuleInjection("ArmyStorageOutfit",
    "Base.Armour_PouchStrap", 0.4,
    "Base.Armour_Faulds", 0.4,
    "Base.Armour_Faulds_Short", 0.4,
    "Base.Armour_ShoulderPad_R", 0.4,
    "Base.Armour_ShoulderPad_L", 0.4,
    "Base.Armour_Armguards_R", 0.4,
    "Base.Armour_Armguards_L", 0.4
)

BatchRuleInjection("WildWestBlacksmith",
    "Base.Armour_PouchStrap", 3.0,
    "Base.TannedLeather_Sleeves_L", 3.0,
    "Base.TannedLeather_Sleeves_R", 3.0,
    "Base.TannedLeather_SleevesLeg_L", 3.0,
    "Base.TannedLeather_SleevesLeg_R", 3.0
)

BatchRuleInjection("CampingStoreClothes",
    "Base.TannedLeather_Jacket_O", 0.4,
    "Base.TannedLeather_LongCoat_O", 0.4,
    "Base.FurJacketShort_O", 0.4,
    "Base.FF_Boots_Leather", 0.4,
    "Base.FF_Shoe_Moccasin", 0.7,
    "Base.Lumberjack_Shirt_10", 0.4
)

BatchRuleInjection("HuntingLockers",
    "Base.TannedLeather_Jacket_O", 0.4,
    "Base.TannedLeather_LongCoat_O", 0.4,
    "Base.FurJacketShort_O", 0.7,
    "Base.FF_Boots_Leather", 0.7,
    "Base.FF_Shoe_Moccasin", 0.8,
    "Base.Hat_Cowboy_Flat", 0.4,
	"Base.Belt_Generic",0.4,
	"Base.Belt_Cowboy",0.4,
	"Base.Belt_Gemstone",0.4,
	"Base.Belt_Gold",0.4,
	"Base.Belt_Silver",0.4,
	"Base.BeltLarge_Skulls",0.4,
	"Base.BeltLarge",0.4,
	"Base.BeltLarge_Gemstone",0.4,
	"Base.BeltLarge_Star",0.4,
	"Base.BeltLarge_Letters",0.4,
	"Base.BeltLargeFur",0.4,
	"Base.Accessory_Wild_Rag",0.4,
	"Base.Accessory_Wild_Rag_Bandana",0.4,
	"Base.Accessory_Wild_Rag_Scarf",0.4,
	"Base.Accessory_Tie_Bolo",0.4,
	"Base.Accessory_Tie_Bolo_Letters",0.4,
	"Base.Accessory_Tie_Bolo_Star",0.4,
	"Base.Accessory_Tie_Bolo_Sun",0.4,
	"Base.Accessory_Tie_Bolo_Moon",0.4
)

BatchRuleInjection("BandMerchClothes",
    "Base.Denim_Jacket_O", 0.7,
    "Base.Denim_Jacket_Cropped", 0.4,
    "Base.TannedLeather_Jacket_O", 0.4,
    "Base.TannedLeather_Jacket_Cropped", 0.4,
    "Base.FF_Boots_PlatformPunk_Thighhigh", 0.4,
    "Base.FF_Boots_PlatformPunk_Kneehigher", 0.4,
    "Base.FF_Boots_PlatformPunk_Kneehigh", 0.4
)

BatchRuleInjection("ClothingRack",
    "Base.Cotton_Blouse", 0.4,
    "Base.Denim_Top", 0.7,
    "Base.Denim_Jacket_O", 0.8,
    "Base.TannedLeather_Jacket_O", 0.7,
    "Base.Denim_Skirt_Short", 0.4,
    "Base.Denim_Skirt_Long", 0.7,
	"Base.Cotton_Blouse", 0.4,
    "Base.Cotton_Blouse_V", 0.8,
    "Base.Cotton_Blouse_V_Cropped", 0.4,
    "Base.Cotton_Blouse_V_Cropped_Tiny", 0.4,
    "Base.Lumberjack_Shirt_10", 0.7,
    "Base.Lumberjack_Cropped_Shirt_10", 0.4,
    "Base.Lumberjack_Sleeveless_Shirt_10", 0.4,
    "Base.Denim_Shirt_10", 0.8,
    "Base.Denim_Sleeveless_Shirt_10", 0.7
)

BatchRuleInjection("BedroomDresser",
    "Base.Cotton_Blouse", 0.4,
    "Base.Lumberjack_Shirt_10", 0.4,
    "Base.Denim_Shirt_10", 0.4,
    "Base.Denim_Shorts_J", 0.4,
    "Base.FF_Shoe_Common", 0.4,
    "Base.FF_Shoe_Trainers", 0.4,
	"Base.Denim_Bandeau", 0.4,
	"Base.Denim_Bandeau_Tiny", 0.4,
	"Base.Denim_Top", 0.4,
	"Base.Denim_CropTop", 0.4,
	"Base.Denim_Skirt_Short", 0.4,
	"Base.Denim_Skirt_Short_LW", 0.4,
	"Base.Denim_Skirt_Longer", 0.4,
	"Base.Denim_Skirt_Long", 0.4,
	"Base.Denim_Skirt_Mesh_HW", 0.4,
	"Base.Denim_Skirt_Mesh_LW", 0.4,
	"Base.Denim_SkirtPleated", 0.4,
	"Base.Denim_SkirtPleated_Frilled", 0.4,
	"Base.Mesh_Denim_Skirt_Longer", 0.4,
	"Base.Mesh_Denim_Pants", 0.4,
	"Base.Mesh_Denim_PantsFlared", 0.4,
	"Base.Mesh_Denim_PantsChaps", 0.4,
	"Base.Mesh_Denim_LongShorts", 0.4,
	"Base.Skin_Denim_Pants_High", 0.4,
	"Base.Skin_Denim_Pants_J", 0.4,
	"Base.Skin_Denim_Pants_Low", 0.4,
	"Base.Skin_Denim_Pants_Lower", 0.4,
	"Base.Skin_Denim_Pants_V", 0.4,
	"Base.Mesh_Denim_Shorts", 0.4,
	"Base.Mesh_Denim_ShortShorts", 0.4,
	"Base.Mesh_Denim_ShorterShorts", 0.4,
	"Base.Skin_Denim_Shorts", 0.4,
	"Base.Denim_Shorts_High", 0.4,
	"Base.Denim_Shorts_J", 0.4,
	"Base.Denim_Shorts_Low", 0.4,
	"Base.Denim_Shorts_Lower", 0.4,
	"Base.Denim_Shorts_V", 0.4,
	"Base.Denim_Overshirt", 0.4,
	"Base.Denim_Overshirt_O", 0.4,
	"Base.Denim_Shirt_10", 0.4,
	"Base.Denim_Shirt_11", 0.4,
	"Base.Denim_Shirt_12", 0.4,
	"Base.Denim_Shirt_15", 0.4,
	"Base.Denim_Shirt_20", 0.4,
	"Base.Denim_Shirt_21", 0.4,
	"Base.Denim_Shirt_22", 0.4,
	"Base.Denim_Shirt_25", 0.4,
	"Base.Denim_Sleeveless_Shirt_10", 0.4,
	"Base.Denim_Sleeveless_Shirt_11", 0.4,
	"Base.Denim_Sleeveless_Shirt_12", 0.4,
	"Base.Denim_Sleeveless_Shirt_15", 0.4,
	"Base.FurCoat_Fur", 0.4,
	"Base.FurJacketShort_O", 0.4,
	"Base.Belt_Generic", 0.4,
	"Base.Belt_Cowboy", 0.4,
	"Base.Belt_Gemstone", 0.4,
	"Base.Belt_Gold", 0.4,
	"Base.Belt_Silver", 0.4,
	"Base.BeltLarge_Skulls", 0.4,
	"Base.BeltLarge", 0.4,
	"Base.BeltLarge_Gemstone", 0.4,
	"Base.BeltLarge_Star", 0.4,
	"Base.BeltLarge_Letters", 0.4,
	"Base.BeltLargeFur", 0.4,
	"Base.Accessory_Wild_Rag", 0.4,
	"Base.Accessory_Wild_Rag_Bandana", 0.4,
	"Base.Accessory_Wild_Rag_Scarf", 0.4
)

BatchRuleInjection("BedroomDresser",
	"Base.Accessory_Tie_Bolo", 0.4,
	"Base.Accessory_Tie_Bolo_Letters", 0.4,
	"Base.Accessory_Tie_Bolo_Star", 0.4,
	"Base.Accessory_Tie_Bolo_Sun", 0.4,
	"Base.Accessory_Tie_Bolo_Moon", 0.4,
	"Base.TannedLeather_Jacket_Cropped", 0.4,
	"Base.TannedLeather_LongestCoat", 0.4,
	"Base.TannedLeather_LongestCoat_O", 0.4,
	"Base.TannedLeather_LongerCoat", 0.4,
	"Base.TannedLeather_LongerCoat_O", 0.4,
	"Base.TannedLeather_LongCoat", 0.4,
	"Base.TannedLeather_LongCoat_O", 0.4,
	"Base.TannedLeather_Jacket", 0.4,
	"Base.TannedLeather_Jacket_O", 0.4,
	"Base.TannedLeather_Jacket_MidLength", 0.4,
	"Base.TannedLeather_Jacket_MidLength_O", 0.4,
	"Base.TannedLeather_TrenchCoat_Long_O", 0.4,
	"Base.TannedLeather_TrenchCoat_Short_O", 0.4,
	"Base.TannedLeather_LongestCoat_Winter", 0.4,
	"Base.TannedLeather_LongestCoat_Winter_O", 0.4,
	"Base.TannedLeather_LongerCoat_Winter", 0.4,
	"Base.TannedLeather_LongerCoat_Winter_O", 0.4,
	"Base.TannedLeather_WaistCoat", 0.4,
	"Base.TannedLeather_WaistCoat_O", 0.4,
	"Base.TMesh_TannedLeather_Pants", 0.4,
	"Base.TMesh_TannedLeather_LongShorts", 0.4,
	"Base.TMesh_TannedLeather_Shorts", 0.4,
	"Base.TMesh_TannedLeather_ShortShorts", 0.4,
	"Base.TMesh_TannedLeather_ShorterShorts", 0.4,
	"Base.TSkin_TannedLeather_Pants_High", 0.4,
	"Base.TSkin_TannedLeather_Pants", 0.4,
	"Base.TSkin_TannedLeather_Pants_Low", 0.4,
	"Base.TSkin_TannedLeather_Pants_Lower", 0.4,
	"Base.TSkin_TannedLeather_Pants_V", 0.4,
	"Base.TannedLeather_Shorts_High", 0.4,
	"Base.TannedLeather_Shorts_J", 0.4,
	"Base.TannedLeather_Shorts_Low", 0.4,
	"Base.TannedLeather_Shorts_Lower", 0.4,
	"Base.TannedLeather_Shorts_V", 0.4,
	"Base.TannedLeather_Skirt_Mesh_HW", 0.4,
	"Base.TannedLeather_Skirt_Mesh_LW", 0.4,
	"Base.TannedLeather_Skirt_Mesh_LerW", 0.4,
	"Base.TannedLeather_Skirt_MeshFrilled_HW", 0.4,
	"Base.TannedLeather_Skirt_MeshFrilled_LW", 0.4,
	"Base.TannedLeather_Skirt_MeshFrilled_LerW", 0.4,
	"Base.TannedLeather_SkirtMicro_Mesh", 0.4,
	"Base.TannedLeather_SkirtMicro_MeshFrilled", 0.4
)

BatchRuleInjection("BedroomDresserClassy",
    "Base.Cotton_Blouse_V", 0.4,
    "Base.Cotton_Blouse_V_Cropped", 0.4,
    "Base.TannedLeather_WaistCoat", 0.4,
    "Base.TannedLeather_Corset_OuterLayer", 0.4,
    "Base.FF_Boots_HighHeels", 0.4,
    "Base.FF_Shoe_Women", 0.4,
	"Base.Cotton_Blouse", 0.4,
    "Base.Cotton_Blouse_V", 0.8,
    "Base.Cotton_Blouse_V_Cropped", 0.4,
    "Base.Cotton_Blouse_V_Cropped_Tiny", 0.4,
    "Base.Lumberjack_Shirt_10", 0.7,
    "Base.Lumberjack_Cropped_Shirt_10", 0.4,
    "Base.Lumberjack_Sleeveless_Shirt_10", 0.4,
    "Base.Denim_Shirt_10", 0.8,
    "Base.Denim_Sleeveless_Shirt_10", 0.7,
	"Base.Denim_Skirt_Short", 0.4,
	"Base.Denim_Skirt_Short_LW", 0.4,
	"Base.Denim_Skirt_Longer", 0.4,
	"Base.Denim_Skirt_Long", 0.4,
	"Base.Denim_Skirt_Mesh_HW", 0.4,
	"Base.Denim_Skirt_Mesh_LW", 0.4,
	"Base.Denim_SkirtPleated", 0.4,
	"Base.Denim_SkirtPleated_Frilled", 0.4,
	"Base.Mesh_Denim_Skirt_Longer", 0.4,
	"Base.Mesh_Denim_Pants", 0.4,
	"Base.Mesh_Denim_PantsFlared", 0.4,
	"Base.Mesh_Denim_PantsChaps", 0.4,
	"Base.Mesh_Denim_LongShorts", 0.4,
	"Base.Skin_Denim_Pants_High", 0.4,
	"Base.Skin_Denim_Pants_J", 0.4,
	"Base.Skin_Denim_Pants_Low", 0.4,
	"Base.Skin_Denim_Pants_Lower", 0.4,
	"Base.Skin_Denim_Pants_V", 0.4,
	"Base.Mesh_Denim_Shorts", 0.4,
	"Base.Mesh_Denim_ShortShorts", 0.4,
	"Base.Mesh_Denim_ShorterShorts", 0.4,
	"Base.Skin_Denim_Shorts", 0.4,
	"Base.Denim_Shorts_High", 0.4,
	"Base.Denim_Shorts_J", 0.4,
	"Base.Denim_Shorts_Low", 0.4,
	"Base.Denim_Shorts_Lower", 0.4,
	"Base.Denim_Shorts_V", 0.4,
	"Base.Denim_Overshirt", 0.4,
	"Base.Denim_Overshirt_O", 0.4,
	"Base.Denim_Shirt_10", 0.4,
	"Base.Denim_Shirt_15", 0.4,
	"Base.Denim_Shirt_20", 0.4,
	"Base.Denim_Shirt_25", 0.4,
	"Base.Denim_Sleeveless_Shirt_10", 0.4,
	"Base.Denim_Sleeveless_Shirt_15", 0.4,
	"Base.FurCoat_Fur", 0.4,
	"Base.FurJacketShort_O", 0.4,
	"Base.Belt_Generic", 0.4
)

BatchRuleInjection("BedroomDresserClassy",
	"Base.Belt_Cowboy", 0.4,
	"Base.Belt_Gemstone", 0.4,
	"Base.Belt_Gold", 0.4,
	"Base.Belt_Silver", 0.4,
	"Base.BeltLarge_Skulls", 0.4,
	"Base.BeltLarge", 0.4,
	"Base.BeltLarge_Gemstone", 0.4,
	"Base.BeltLarge_Star", 0.4,
	"Base.BeltLarge_Letters", 0.4,
	"Base.BeltLargeFur", 0.4,
	"Base.Accessory_Wild_Rag", 0.4,
	"Base.Accessory_Wild_Rag_Bandana", 0.4,
	"Base.Accessory_Wild_Rag_Scarf", 0.4,
	"Base.Accessory_Tie_Bolo", 0.4,
	"Base.Accessory_Tie_Bolo_Letters", 0.4,
	"Base.Accessory_Tie_Bolo_Star", 0.4,
	"Base.Accessory_Tie_Bolo_Sun", 0.4,
	"Base.Accessory_Tie_Bolo_Moon", 0.4,
	"Base.TannedLeather_WaistCoat", 0.4,
	"Base.TannedLeather_WaistCoat_O", 0.4,
	"Base.TMesh_TannedLeather_Pants", 0.4,
	"Base.TMesh_TannedLeather_LongShorts", 0.4,
	"Base.TMesh_TannedLeather_Shorts", 0.4,
	"Base.TMesh_TannedLeather_ShortShorts", 0.4,
	"Base.TMesh_TannedLeather_ShorterShorts", 0.4,
	"Base.TannedLeather_Leotard", 0.4,
	"Base.TannedLeather_Leotard_MC", 0.4,
	"Base.TannedLeather_Leotard_HC", 0.4,
	"Base.TannedLeather_LeotardUB", 0.4,
	"Base.TannedLeather_LeotardUB_MC", 0.4,
	"Base.TannedLeather_LeotardUB_HC", 0.4,
	"Base.TSkin_TannedLeather_Pants_High", 0.4,
	"Base.TSkin_TannedLeather_Pants", 0.4,
	"Base.TSkin_TannedLeather_Pants_Low", 0.4,
	"Base.TSkin_TannedLeather_Pants_Lower", 0.4,
	"Base.TSkin_TannedLeather_Pants_V", 0.4,
	"Base.TannedLeather_Shorts_High", 0.4,
	"Base.TannedLeather_Shorts_J", 0.4,
	"Base.TannedLeather_Shorts_Low", 0.4,
	"Base.TannedLeather_Shorts_Lower", 0.4,
	"Base.TannedLeather_Shorts_V", 0.4,
	"Base.TannedLeather_Skirt_Mesh_HW", 0.4,
	"Base.TannedLeather_Skirt_Mesh_LW", 0.4,
	"Base.TannedLeather_Skirt_Mesh_LerW", 0.4,
	"Base.TannedLeather_Skirt_MeshFrilled_HW", 0.4,
	"Base.TannedLeather_Skirt_MeshFrilled_LW", 0.4,
	"Base.TannedLeather_Skirt_MeshFrilled_LerW", 0.4,
	"Base.TannedLeather_SkirtMicro_Mesh", 0.4,
	"Base.TannedLeather_SkirtMicro_MeshFrilled", 0.4
)

BatchRuleInjection("BedroomDresserRedneck",
    "Base.Lumberjack_Shirt_10", 0.8,
    "Base.Lumberjack_Cropped_Shirt_10", 0.7,
    "Base.Denim_Shirt_10", 0.7,
    "Base.Denim_Shorts_J", 0.4,
    "Base.FF_Boots_Cowboy", 0.4,
    "Base.FF_Boots_Cowboy_Plain", 0.4,
    "Base.FF_Shoe_Common", 0.4
)

BatchRuleInjection("BedroomSidetable",
	"Base.Belt_Generic",0.4,
	"Base.Belt_Cowboy",0.4,
	"Base.Belt_Gemstone",0.4,
	"Base.Belt_Gold",0.4,
	"Base.Belt_Silver",0.4,
	"Base.BeltLarge_Skulls",0.4,
	"Base.BeltLarge",0.4,
	"Base.BeltLarge_Gemstone",0.4,
	"Base.BeltLarge_Star",0.4,
	"Base.BeltLarge_Letters",0.4,
	"Base.BeltLargeFur",0.4,
	"Base.Accessory_Wild_Rag",0.4,
	"Base.Accessory_Wild_Rag_Bandana",0.4,
	"Base.Accessory_Wild_Rag_Scarf",0.4,
	"Base.Accessory_Tie_Bolo",0.4,
	"Base.Accessory_Tie_Bolo_Letters",0.4,
	"Base.Accessory_Tie_Bolo_Star",0.4,
	"Base.Accessory_Tie_Bolo_Sun",0.4,
	"Base.Accessory_Tie_Bolo_Moon",0.4
)

BatchRuleInjection("BedroomSidetableClassy",
    "Base.Belt_Gold", 0.4,
    "Base.Belt_Silver", 0.4,
    "Base.Accessory_Tie_Bolo", 0.4,
    "Base.Accessory_Tie_Bolo_Star", 0.4,
    "Base.FF_Boots_HighHeels", 0.4
)

BatchRuleInjection("BedroomSidetableRedneck",
    "Base.Belt_Generic", 0.4,
    "Base.Belt_Cowboy", 0.4,
    "Base.Accessory_Wild_Rag", 0.4,
    "Base.Accessory_Wild_Rag_Bandana", 0.7,
	"Base.Accessory_Wild_Rag_Scarf", 0.4,
    "Base.FF_Shoe_Common", 0.4
)

BatchRuleInjection("WardrobeGeneric",
    "Base.Denim_Jacket_O", 0.3,
    "Base.TannedLeather_Jacket_O", 0.3,
    "Base.FurJacketShort_O", 0.3,
    "Base.Denim_Skirt_Short", 0.3,
    "Base.Denim_Skirt_Long", 0.3,
    "Base.FF_Boots_Common", 0.3,
    "Base.FF_Shoe_Common", 0.3,
	"Base.Cotton_Blouse", 0.3,
    "Base.Cotton_Blouse_V", 0.8,
    "Base.Cotton_Blouse_V_Cropped", 0.3,
    "Base.Cotton_Blouse_V_Cropped_Tiny", 0.3,
    "Base.Lumberjack_Shirt_10", 0.7,
    "Base.Lumberjack_Cropped_Shirt_10", 0.3,
    "Base.Lumberjack_Sleeveless_Shirt_10", 0.3,
    "Base.Denim_Shirt_10", 0.8,
    "Base.Denim_Sleeveless_Shirt_10", 0.7,
	"Base.Mesh_Denim_Pants",0.3,
	"Base.Mesh_Denim_PantsFlared",0.3,
	"Base.Mesh_Denim_PantsChaps",0.3,
	"Base.Mesh_Denim_LongShorts",0.3,
	"Base.Skin_Denim_Pants_J",0.3,
	"Base.Mesh_Denim_Shorts",0.3,
	"Base.Mesh_Denim_ShortShorts",0.3,
	"Base.Mesh_Denim_ShorterShorts",0.3,
	"Base.Skin_Denim_Shorts",0.3,
	"Base.Denim_Shorts_J",0.3,
	"Base.TMesh_TannedLeather_Pants",0.3,
	"Base.TMesh_TannedLeather_LongShorts",0.3,
	"Base.TMesh_TannedLeather_Shorts",0.3,
	"Base.TMesh_TannedLeather_ShortShorts",0.3,
	"Base.TMesh_TannedLeather_ShorterShorts",0.3,
	"Base.TSkin_TannedLeather_Pants",0.3,
	"Base.TannedLeather_Shorts_J",0.3,
	"Base.Denim_Skirt_Short", 0.3,
	"Base.Denim_Skirt_Short_LW", 0.3,
	"Base.Denim_Skirt_Longer", 0.3,
	"Base.Denim_LongCoat", 0.75,
	"Base.Denim_LongCoat_O", 0.75,
	"Base.Denim_LongCoatShort", 0.75,
	"Base.Denim_LongCoatShort_O", 0.75,
	"Base.Denim_LongCoatShort_Reinforced", 0.75,
	"Base.Denim_LongCoatShort_Reinforced_O", 0.75,
	"Base.Denim_LongCoatShortSleeveless", 0.75,
	"Base.Denim_LongCoatShortSleeveless_O", 0.75,
	"Base.Lumberjack_Shirt_10", 2,
    "Base.Lumberjack_Cropped_Shirt_10", 0.75,
    "Base.Lumberjack_Sleeveless_Shirt_10", 0.75,
	"Base.Denim_TrenchCoat_Long_O", 0.75,
	"Base.Denim_TrenchCoat_Short_O", 1
)

BatchRuleInjection("WardrobeGeneric",
	"Base.Denim_Skirt_Long", 0.3,
	"Base.Denim_Skirt_Mesh_HW", 0.3,
	"Base.Denim_Skirt_Mesh_LW", 0.3,
	"Base.Denim_SkirtPleated", 0.3,
	"Base.Denim_SkirtPleated_Frilled", 0.3,
	"Base.Mesh_Denim_Skirt_Longer", 0.3,
	"Base.Mesh_Denim_Pants", 0.3,
	"Base.Mesh_Denim_PantsFlared", 0.3,
	"Base.Mesh_Denim_PantsChaps", 0.3,
	"Base.Mesh_Denim_LongShorts", 0.3,
	"Base.Skin_Denim_Pants_High", 0.3,
	"Base.Skin_Denim_Pants_J", 0.3,
	"Base.Skin_Denim_Pants_Low", 0.3,
	"Base.Skin_Denim_Pants_Lower", 0.3,
	"Base.Skin_Denim_Pants_V", 0.3,
	"Base.Mesh_Denim_Shorts", 0.3,
	"Base.Mesh_Denim_ShortShorts", 0.3,
	"Base.Mesh_Denim_ShorterShorts", 0.3,
	"Base.Skin_Denim_Shorts", 0.3,
	"Base.Denim_Shorts_High", 0.3,
	"Base.Denim_Shorts_J", 0.3,
	"Base.Denim_Shorts_Low", 0.3,
	"Base.Denim_Shorts_Lower", 0.3,
	"Base.Denim_Shorts_V", 0.3,
	"Base.Denim_Overshirt", 0.3,
	"Base.Denim_Overshirt_O", 0.3,
	"Base.Denim_Shirt_10", 0.3,
	"Base.Denim_Shirt_15", 0.3,
	"Base.Denim_Shirt_20", 0.3,
	"Base.Denim_Shirt_25", 0.3,
	"Base.Denim_Sleeveless_Shirt_10", 0.3,
	"Base.Denim_Sleeveless_Shirt_15", 0.3,
	"Base.FurCoat_Fur", 0.3,
	"Base.FurJacketShort_O", 0.3,
	"Base.Belt_Generic", 0.3,
	"Base.Belt_Cowboy", 0.3,
	"Base.Belt_Gemstone", 0.3,
	"Base.Belt_Gold", 0.3,
	"Base.Belt_Silver", 0.3,
	"Base.BeltLarge_Skulls", 0.3,
	"Base.BeltLarge", 0.3,
	"Base.BeltLarge_Gemstone", 0.3
)

BatchRuleInjection("WardrobeGeneric",
	"Base.BeltLarge_Star", 0.3,
	"Base.BeltLarge_Letters", 0.3,
	"Base.BeltLargeFur", 0.3,
	"Base.Accessory_Wild_Rag", 0.3,
	"Base.Accessory_Wild_Rag_Bandana", 0.3,
	"Base.Accessory_Wild_Rag_Scarf", 0.3,
	"Base.Accessory_Tie_Bolo", 0.3,
	"Base.Accessory_Tie_Bolo_Letters", 0.3,
	"Base.Accessory_Tie_Bolo_Star", 0.3,
	"Base.Accessory_Tie_Bolo_Sun", 0.3,
	"Base.Accessory_Tie_Bolo_Moon", 0.3,
	"Base.TannedLeather_Jacket_Cropped", 0.3,
	"Base.TannedLeather_LongestCoat", 0.3,
	"Base.TannedLeather_LongestCoat_O", 0.3,
	"Base.TannedLeather_LongerCoat", 0.3,
	"Base.TannedLeather_LongerCoat_O", 0.3,
	"Base.TannedLeather_LongCoat", 0.3,
	"Base.TannedLeather_LongCoat_O", 0.3,
	"Base.TannedLeather_Jacket", 0.3,
	"Base.TannedLeather_Jacket_O", 0.3,
	"Base.TannedLeather_Jacket_MidLength", 0.3,
	"Base.TannedLeather_Jacket_MidLength_O", 0.3,
	"Base.TannedLeather_TrenchCoat_Long_O", 0.3,
	"Base.TannedLeather_TrenchCoat_Short_O", 0.3,
	"Base.TannedLeather_LongestCoat_Winter", 0.3,
	"Base.TannedLeather_LongestCoat_Winter_O", 0.3,
	"Base.TannedLeather_LongerCoat_Winter", 0.3,
	"Base.TannedLeather_LongerCoat_Winter_O", 0.3,
	"Base.TannedLeather_Top", 0.3,
	"Base.TannedLeather_TopSkimpy", 0.3
)

BatchRuleInjection("WardrobeGeneric",
	"Base.TannedLeather_WaistCoat", 0.3,
	"Base.TannedLeather_WaistCoat_O", 0.3,
	"Base.TMesh_TannedLeather_Pants", 0.3,
	"Base.TMesh_TannedLeather_LongShorts", 0.3,
	"Base.TMesh_TannedLeather_Shorts", 0.3,
	"Base.TMesh_TannedLeather_ShortShorts", 0.3,
	"Base.TMesh_TannedLeather_ShorterShorts", 0.3,
	"Base.TSkin_TannedLeather_Pants_High", 0.3,
	"Base.TSkin_TannedLeather_Pants", 0.3,
	"Base.TSkin_TannedLeather_Pants_Low", 0.3,
	"Base.TSkin_TannedLeather_Pants_Lower", 0.3,
	"Base.TSkin_TannedLeather_Pants_V", 0.3,
	"Base.TannedLeather_Shorts_High", 0.3,
	"Base.TannedLeather_Shorts_J", 0.3,
	"Base.TannedLeather_Skirt_Mesh_HW", 0.3,
	"Base.TannedLeather_Skirt_Mesh_LW", 0.3,
	"Base.TannedLeather_Skirt_Mesh_LerW", 0.3,
	"Base.TannedLeather_Skirt_MeshFrilled_HW", 0.3,
	"Base.TannedLeather_Skirt_MeshFrilled_LW", 0.3,
	"Base.TannedLeather_Skirt_MeshFrilled_LerW", 0.3,
	"Base.TannedLeather_SkirtMicro_Mesh", 0.3,
	"Base.Lumberjack_Shirt_10", 2,
    "Base.Lumberjack_Cropped_Shirt_10", 0.75,
    "Base.Lumberjack_Sleeveless_Shirt_10", 0.75,
	"Base.TannedLeather_SkirtMicro_MeshFrilled", 0.3
)

BatchRuleInjection("WardrobeClassy",
    "Base.TannedLeather_Jacket_O", 0.4,
    "Base.TannedLeather_LongCoat_O", 0.4,
    "Base.Denim_TrenchCoat_Long_O", 0.4,
    "Base.Cotton_Blouse_V", 0.4,
    "Base.TannedLeather_Skirt_Long", 0.4,
    "Base.FF_Boots_Leather", 0.4,
    "Base.FF_Boots_HighHeels", 0.4,
	"Base.Cotton_Blouse", 0.4,
    "Base.Cotton_Blouse_V", 0.8,
    "Base.Cotton_Blouse_V_Cropped", 0.4,
    "Base.Cotton_Blouse_V_Cropped_Tiny", 0.4,
    "Base.Lumberjack_Shirt_10", 2,
    "Base.Lumberjack_Cropped_Shirt_10", 0.75,
    "Base.Lumberjack_Sleeveless_Shirt_10", 0.75,
    "Base.Denim_Shirt_10", 0.8,
    "Base.Denim_Sleeveless_Shirt_10", 0.7,
	"Base.Mesh_Denim_Pants",0.4,
	"Base.Mesh_Denim_PantsFlared",0.4,
	"Base.Mesh_Denim_PantsChaps",0.4,
	"Base.Mesh_Denim_LongShorts",0.4,
	"Base.Skin_Denim_Pants_J",0.4,
	"Base.Mesh_Denim_Shorts",0.4,
	"Base.Mesh_Denim_ShortShorts",0.4,
	"Base.Mesh_Denim_ShorterShorts",0.4,
	"Base.Skin_Denim_Shorts",0.4,
	"Base.Denim_Shorts_J",0.4,
	"Base.TMesh_TannedLeather_Pants",0.4,
	"Base.TMesh_TannedLeather_LongShorts",0.4,
	"Base.TMesh_TannedLeather_Shorts",0.4,
	"Base.TMesh_TannedLeather_ShortShorts",0.4,
	"Base.TMesh_TannedLeather_ShorterShorts",0.4,
	"Base.TSkin_TannedLeather_Pants",0.4,
	"Base.TannedLeather_Shorts_J",0.4,
	"Base.Denim_Bandeau", 0.4,
	"Base.Denim_Bandeau_Tiny", 0.4,
	"Base.Denim_Top", 0.4,
	"Base.Denim_CropTop", 0.4,
	"Base.Denim_Skirt_Short", 0.4,
	"Base.Denim_Skirt_Short_LW", 0.4,
	"Base.Denim_Skirt_Longer", 0.4,
	"Base.Denim_Skirt_Long", 0.4,
	"Base.Denim_Skirt_Mesh_HW", 0.4
)

BatchRuleInjection("WardrobeClassy",
	"Base.Denim_Skirt_Mesh_LW", 0.4,
	"Base.Denim_SkirtPleated", 0.4,
	"Base.Denim_SkirtPleated_Frilled", 0.4,
	"Base.Mesh_Denim_Skirt_Longer", 0.4,
	"Base.Mesh_Denim_Pants", 0.4,
	"Base.Mesh_Denim_PantsFlared", 0.4,
	"Base.Mesh_Denim_PantsChaps", 0.4,
	"Base.Mesh_Denim_LongShorts", 0.4,
	"Base.Skin_Denim_Pants_High", 0.4,
	"Base.Skin_Denim_Pants_J", 0.4,
	"Base.Skin_Denim_Pants_Low", 0.4,
	"Base.Mesh_Denim_Shorts", 0.4,
	"Base.Mesh_Denim_ShortShorts", 0.4,
	"Base.Mesh_Denim_ShorterShorts", 0.4,
	"Base.Skin_Denim_Shorts", 0.4,
	"Base.Denim_Shorts_High", 0.4,
	"Base.Denim_Shorts_J", 0.4,
	"Base.Denim_Overshirt", 0.4,
	"Base.Denim_Overshirt_O", 0.4,
	"Base.Denim_Shirt_10", 0.4,
	"Base.Denim_Shirt_15", 0.4,
	"Base.Denim_Shirt_20", 0.4,
	"Base.Denim_Shirt_25", 0.4,
	"Base.Denim_Sleeveless_Shirt_10", 0.4,
	"Base.Denim_Sleeveless_Shirt_15", 0.4,
	"Base.FurCoat_Fur", 0.4,
	"Base.FurJacketShort_O", 0.4,
	"Base.Belt_Generic", 0.4,
	"Base.Belt_Cowboy", 0.4,
	"Base.Belt_Gemstone", 0.4,
	"Base.Belt_Gold", 0.4,
	"Base.Belt_Silver", 0.4,
	"Base.BeltLarge_Skulls", 0.4,
	"Base.BeltLarge", 0.4,
	"Base.BeltLarge_Gemstone", 0.4,
	"Base.BeltLarge_Star", 0.4,
	"Base.BeltLarge_Letters", 0.4,
	"Base.BeltLargeFur", 0.4,
	"Base.Denim_LongCoat", 0.75,
	"Base.Denim_LongCoat_O", 0.75,
	"Base.Denim_LongCoatShort", 0.75,
	"Base.Denim_LongCoatShort_O", 0.75,
	"Base.Denim_LongCoatShort_Reinforced", 0.75,
	"Base.Denim_LongCoatShort_Reinforced_O", 0.75,
	"Base.Denim_LongCoatShortSleeveless", 0.75,
	"Base.Denim_LongCoatShortSleeveless_O", 0.75,
	"Base.Denim_TrenchCoat_Long_O", 0.75,
	"Base.Denim_TrenchCoat_Short_O", 1
)

BatchRuleInjection("WardrobeClassy",
	"Base.Accessory_Wild_Rag", 0.4,
	"Base.Accessory_Wild_Rag_Bandana", 0.4,
	"Base.Accessory_Wild_Rag_Scarf", 0.4,
	"Base.Accessory_Tie_Bolo", 0.4,
	"Base.Accessory_Tie_Bolo_Letters", 0.4,
	"Base.Accessory_Tie_Bolo_Star", 0.4,
	"Base.Accessory_Tie_Bolo_Sun", 0.4,
	"Base.Accessory_Tie_Bolo_Moon", 0.4,
	"Base.TannedLeather_Jacket_Cropped", 0.4,
	"Base.TannedLeather_LongestCoat", 0.4,
	"Base.TannedLeather_LongestCoat_O", 0.4,
	"Base.TannedLeather_LongerCoat", 0.4,
	"Base.TannedLeather_LongerCoat_O", 0.4,
	"Base.TannedLeather_LongCoat", 0.4,
	"Base.TannedLeather_LongCoat_O", 0.4,
	"Base.TannedLeather_Jacket", 0.4,
	"Base.TannedLeather_Jacket_O", 0.4,
	"Base.TannedLeather_Jacket_MidLength", 0.4,
	"Base.TannedLeather_Jacket_MidLength_O", 0.4,
	"Base.TannedLeather_TrenchCoat_Long_O", 0.4,
	"Base.TannedLeather_TrenchCoat_Short_O", 0.4,
	"Base.TannedLeather_LongestCoat_Winter", 0.4,
	"Base.TannedLeather_LongestCoat_Winter_O", 0.4,
	"Base.TannedLeather_LongerCoat_Winter", 0.4,
	"Base.TannedLeather_LongerCoat_Winter_O", 0.4,
	"Base.TannedLeather_Top", 0.4,
	"Base.TannedLeather_TopSkimpy", 0.4,
	"Base.TannedLeather_CropTop", 0.4,
	"Base.TannedLeather_Bandeau", 0.4,
	"Base.TannedLeather_Bandeau_Tiny", 0.4,
	"Base.TannedLeather_Corset_OuterLayer", 0.4,
	"Base.TannedLeather_Corset_UB_OuterLayer", 0.4,
	"Base.TannedLeather_Corset_Strap_OuterLayer", 0.4,
	"Base.TannedLeather_Corset_UB_Strap_OuterLayer", 0.4,
	"Base.TannedLeather_WaistCoat_O", 0.4,
	"Base.TMesh_TannedLeather_Pants", 0.4,
	"Base.TMesh_TannedLeather_LongShorts", 0.4,
	"Base.TMesh_TannedLeather_Shorts", 0.4,
	"Base.TMesh_TannedLeather_ShortShorts", 0.4,
	"Base.TMesh_TannedLeather_ShorterShorts", 0.4,
	"Base.TannedLeather_Leotard_MC", 0.4,
	"Base.TannedLeather_LeotardUB_MC", 0.4,
	"Base.TSkin_TannedLeather_Pants_High", 0.4,
	"Base.TSkin_TannedLeather_Pants", 0.4,
	"Base.TannedLeather_Shorts_High", 0.4,
	"Base.TannedLeather_Shorts_J", 0.4,
	"Base.TannedLeather_Skirt_Mesh_HW", 0.4,
	"Base.TannedLeather_Skirt_Mesh_LW", 0.4,
	"Base.TannedLeather_Skirt_Mesh_LerW", 0.4,
	"Base.TannedLeather_Skirt_MeshFrilled_HW", 0.4,
	"Base.TannedLeather_Skirt_MeshFrilled_LW", 0.4,
	"Base.TannedLeather_Skirt_MeshFrilled_LerW", 0.4,
	"Base.TannedLeather_SkirtMicro_Mesh", 0.4,
	"Base.TannedLeather_SkirtMicro_MeshFrilled", 0.4
)

BatchRuleInjection("WardrobeRedneck",
    "Base.Denim_Jacket_O", 0.4,
    "Base.Lumberjack_Shirt_10", 0.7,
    "Base.Denim_Shirt_10", 0.7,
    "Base.Denim_Shorts_J", 0.4,
    "Base.Mesh_Denim_Shorts", 0.4,
    "Base.FF_Boots_Cowboy", 0.4,
    "Base.FF_Boots_Common", 0.4,
    "Base.Hat_Cowboy_Flat", 0.4,
	"Base.Mesh_Denim_Pants",0.4,
	"Base.Mesh_Denim_PantsFlared",0.4,
	"Base.Mesh_Denim_PantsChaps",0.4,
	"Base.Mesh_Denim_LongShorts",0.4,
	"Base.Skin_Denim_Pants_J",0.4,
	"Base.Mesh_Denim_Shorts",0.4,
	"Base.Mesh_Denim_ShortShorts",0.4,
	"Base.Mesh_Denim_ShorterShorts",0.4,
	"Base.Skin_Denim_Shorts",0.4,
	"Base.Denim_Shorts_J",0.4,
	"Base.TMesh_TannedLeather_Pants",0.4,
	"Base.TMesh_TannedLeather_LongShorts",0.4,
	"Base.TMesh_TannedLeather_Shorts",0.4,
	"Base.TMesh_TannedLeather_ShortShorts",0.4,
	"Base.TMesh_TannedLeather_ShorterShorts",0.4,
	"Base.TSkin_TannedLeather_Pants",0.4,
	"Base.TannedLeather_Shorts_J",0.4,
	"Base.Denim_Bandeau", 0.4,
	"Base.Denim_Bandeau_Tiny", 0.4,
	"Base.Denim_Top", 0.4
)

BatchRuleInjection("WardrobeRedneck",
	"Base.Denim_CropTop", 0.4,
	"Base.Denim_Skirt_Short", 0.4,
	"Base.Denim_Skirt_Short_LW", 0.4,
	"Base.Denim_Skirt_Longer", 0.4,
	"Base.Denim_Skirt_Long", 0.4,
	"Base.Denim_Skirt_Mesh_HW", 0.4,
	"Base.Denim_Skirt_Mesh_LW", 0.4,
	"Base.Denim_SkirtPleated", 0.4,
	"Base.Denim_SkirtPleated_Frilled", 0.4,
	"Base.Mesh_Denim_Skirt_Longer", 0.4,
	"Base.Mesh_Denim_Pants", 0.4,
	"Base.Mesh_Denim_PantsFlared", 0.4,
	"Base.Mesh_Denim_PantsChaps", 0.4,
	"Base.Mesh_Denim_LongShorts", 0.4,
	"Base.Skin_Denim_Pants_High", 0.4,
	"Base.Skin_Denim_Pants_J", 0.4,
	"Base.Skin_Denim_Pants_Low", 0.4,
	"Base.Skin_Denim_Pants_Lower", 0.4,
	"Base.Skin_Denim_Pants_V", 0.4,
	"Base.Mesh_Denim_Shorts", 0.4,
	"Base.Mesh_Denim_ShortShorts", 0.4,
	"Base.Mesh_Denim_ShorterShorts", 0.4,
	"Base.Skin_Denim_Shorts", 0.4,
	"Base.Denim_Shorts_High", 0.4,
	"Base.Denim_Shorts_J", 0.4,
	"Base.Denim_Shorts_Low", 0.4,
	"Base.Denim_Shorts_Lower", 0.4,
	"Base.Denim_Shorts_V", 0.4,
	"Base.Denim_Overshirt", 0.4,
	"Base.Denim_Overshirt_O", 0.4,
	"Base.Denim_Shirt_10", 0.4,
	"Base.Denim_Shirt_15", 0.4,
	"Base.Denim_Shirt_20", 0.4,
	"Base.Denim_Shirt_25", 0.4
)	

BatchRuleInjection("WardrobeRedneck",
	"Base.Denim_Sleeveless_Shirt_10", 0.4,
	"Base.Denim_Sleeveless_Shirt_15", 0.4,
	"Base.FurCoat_Fur", 0.4,
	"Base.FurJacketShort_O", 0.4,
	"Base.Belt_Generic", 0.4,
	"Base.Belt_Cowboy", 0.4,
	"Base.Belt_Gemstone", 0.4,
	"Base.Belt_Gold", 0.4,
	"Base.Belt_Silver", 0.4,
	"Base.BeltLarge_Skulls", 0.4,
	"Base.BeltLarge", 0.4,
	"Base.BeltLarge_Gemstone", 0.4,
	"Base.BeltLarge_Star", 0.4,
	"Base.BeltLarge_Letters", 0.4,
	"Base.BeltLargeFur", 0.4,
	"Base.Accessory_Wild_Rag", 0.4,
	"Base.Accessory_Wild_Rag_Bandana", 0.4,
	"Base.Accessory_Wild_Rag_Scarf", 0.4,
	"Base.Accessory_Tie_Bolo", 0.4,
	"Base.Accessory_Tie_Bolo_Letters", 0.4,
	"Base.Accessory_Tie_Bolo_Star", 0.4,
	"Base.Accessory_Tie_Bolo_Sun", 0.4,
	"Base.Accessory_Tie_Bolo_Moon", 0.4,
	"Base.TannedLeather_Jacket_Cropped", 0.4,
	"Base.TannedLeather_LongestCoat", 0.4,
	"Base.TannedLeather_LongestCoat_O", 0.4,
	"Base.TannedLeather_LongerCoat", 0.4,
	"Base.TannedLeather_LongerCoat_O", 0.4,
	"Base.TannedLeather_LongCoat", 0.4,
	"Base.TannedLeather_LongCoat_O", 0.4,
	"Base.TannedLeather_Jacket", 0.4,
	"Base.TannedLeather_Jacket_O", 0.4,
	"Base.TannedLeather_Jacket_MidLength", 0.4,
	"Base.TannedLeather_Jacket_MidLength_O", 0.4,
	"Base.TannedLeather_TrenchCoat_Long_O", 0.4,
	"Base.TannedLeather_TrenchCoat_Short_O", 0.4,
	"Base.TannedLeather_LongestCoat_Winter", 0.4,
	"Base.TannedLeather_LongestCoat_Winter_O", 0.4,
	"Base.TannedLeather_LongerCoat_Winter", 0.4,
	"Base.TannedLeather_LongerCoat_Winter_O", 0.4,
	"Base.TannedLeather_Top", 0.4,
	"Base.TannedLeather_TopSkimpy", 0.4,
	"Base.TannedLeather_CropTop", 0.4,
	"Base.TannedLeather_Bandeau", 0.4,
	"Base.TannedLeather_Bandeau_Tiny", 0.4,
	"Base.TannedLeather_Corset_OuterLayer", 0.4,
	"Base.TannedLeather_Corset_UB_OuterLayer", 0.4,
	"Base.TannedLeather_Corset_Strap_OuterLayer", 0.4
)

BatchRuleInjection("WardrobeRedneck",
	"Base.TannedLeather_Corset_UB_Strap_OuterLayer", 0.4,
	"Base.TannedLeather_WaistCoat_O", 0.4,
	"Base.TMesh_TannedLeather_Pants", 0.4,
	"Base.TMesh_TannedLeather_LongShorts", 0.4,
	"Base.TMesh_TannedLeather_Shorts", 0.4,
	"Base.TMesh_TannedLeather_ShortShorts", 0.4,
	"Base.TMesh_TannedLeather_ShorterShorts", 0.4,
	"Base.TSkin_TannedLeather_Pants", 0.4,
	"Base.TSkin_TannedLeather_Pants_Low", 0.4,
	"Base.TannedLeather_Shorts_J", 0.4,
	"Base.TannedLeather_Shorts_V", 0.4,
	"Base.TannedLeather_Skirt_Mesh_HW", 0.4,
	"Base.TannedLeather_Skirt_Mesh_LW", 0.4,
	"Base.TannedLeather_Skirt_Mesh_LerW", 0.4,
	"Base.TannedLeather_Skirt_MeshFrilled_HW", 0.4,
	"Base.TannedLeather_Skirt_MeshFrilled_LW", 0.4,
	"Base.TannedLeather_Skirt_MeshFrilled_LerW", 0.4,
	"Base.TannedLeather_SkirtMicro_Mesh", 0.4,
	"Base.TannedLeather_SkirtMicro_MeshFrilled", 0.4
)

BatchRuleInjection("ClosetShelfGeneric",
    "Base.Cotton_Blouse", 0.4,
    "Base.Lumberjack_Shirt_10", 0.4,
    "Base.Denim_Shirt_10", 0.4,
    "Base.Denim_Shorts_J", 0.4,
    "Base.Denim_Skirt_Short", 0.4,
    "Base.FF_Shoe_Common", 0.4,
    "Base.FF_Shoe_Trainers", 0.4,
    "Base.Belt_Generic", 0.4,
	"Base.Belt_Generic",0.4,
	"Base.Belt_Cowboy",0.4,
	"Base.Belt_Gemstone",0.4,
	"Base.Belt_Gold",0.4,
	"Base.Belt_Silver",0.4,
	"Base.BeltLarge_Skulls",0.4,
	"Base.BeltLarge",0.4,
	"Base.BeltLarge_Gemstone",0.4,
	"Base.BeltLarge_Star",0.4,
	"Base.BeltLarge_Letters",0.4,
	"Base.BeltLargeFur",0.4,
	"Base.Accessory_Wild_Rag",0.4,
	"Base.Accessory_Wild_Rag_Bandana",0.4,
	"Base.Accessory_Wild_Rag_Scarf",0.4,
	"Base.Accessory_Tie_Bolo",0.4,
	"Base.Accessory_Tie_Bolo_Letters",0.4,
	"Base.Accessory_Tie_Bolo_Star",0.4,
	"Base.Accessory_Tie_Bolo_Sun",0.4,
	"Base.Accessory_Tie_Bolo_Moon",0.4,
	"Base.Denim_Jacket_Cropped", 0.75,
	"Base.Denim_Jacket", 0.75,
	"Base.Denim_Jacket_O", 0.75,
	"Base.Denim_JacketReinforced", 0.75,
	"Base.Denim_JacketReinforced_O", 0.75,
	"Base.Denim_JacketShort", 0.75,
	"Base.Denim_JacketShort_O", 0.75,
	"Base.Denim_VestJacket", 0.75,
	"Base.Denim_VestJacket_O", 0.75,
	"Base.Denim_VestJacketCropped", 0.75,
	"Base.Denim_VestJacketCropped_O", 0.75,
	"Base.Denim_VestJacketShort", 0.75,
	"Base.Denim_VestJacketShort_O", 0.75,
	"Base.Denim_LongCoat", 0.75,
	"Base.Denim_LongCoat_O", 0.75,
	"Base.Denim_LongCoatShort", 0.75,
	"Base.Denim_LongCoatShort_O", 0.75,
	"Base.Denim_LongCoatShort_Reinforced", 0.75,
	"Base.Denim_LongCoatShort_Reinforced_O", 0.75,
	"Base.Denim_LongCoatShortSleeveless", 0.75,
	"Base.Denim_LongCoatShortSleeveless_O", 0.75,
	"Base.Denim_TrenchCoat_Long_O", 0.75,
	"Base.Denim_TrenchCoat_Short_O", 0.75,
	"Base.TannedLeather_Jacket_Cropped", 0.75,
	"Base.TannedLeather_LongestCoat", 0.75,
	"Base.TannedLeather_LongestCoat_O", 0.75,
	"Base.TannedLeather_LongerCoat", 0.75,
	"Base.TannedLeather_LongerCoat_O", 0.75,
	"Base.TannedLeather_LongCoat", 0.75,
	"Base.TannedLeather_LongCoat_O", 0.75,
	"Base.TannedLeather_Jacket", 0.75,
	"Base.TannedLeather_Jacket_O", 0.75,
	"Base.TannedLeather_Jacket_MidLength_O", 0.75,
	"Base.TannedLeather_TrenchCoat_Long_O", 0.75,
	"Base.TannedLeather_TrenchCoat_Short_O", 0.75,
	"Base.TannedLeather_LongestCoat_Winter_O", 0.75,
	"Base.TannedLeather_LongerCoat_Winter_O", 0.75,
	"Base.Cotton_LongestCoat_VintageMil_O", 1
)

BatchRuleInjection("Locker",
    "Base.FF_Boots_HF_New", 0.4,
	"Base.FF_Boots_HF_New_Longest", 0.4,
	"Base.FF_Boots_HF_New_Longer", 0.4,
	"Base.FF_Boots_HF_New_Long", 0.4,
	"Base.FF_Shoe_Boots_Ankle_Platform", 0.4,
	"Base.FF_Boots_HighHeels", 0.4,
	"Base.FF_Shoe_Women", 0.4,
	"Base.FF_Shoe_Women_Platform", 0.4,
	"Base.FF_Shoe_Women_2", 0.4,
	"Base.FF_Shoe_Moccasin", 0.4,
	"Base.FF_Boots_UGG_DwarfHeel", 0.4,
	"Base.FF_Boots_UGG_Heel", 0.4,
	"Base.FF_Boots_UGG_ThighhighHeel", 0.4,
	"Base.FF_Boots_UGG_KneehighHeel", 0.4,
	"Base.FF_Boots_UGG", 0.4,
	"Base.FF_Boots_UGG_Thighhigh", 0.4,
	"Base.FF_Boots_UGG_Kneehigh", 0.4,
	"Base.FF_Boots_Leather", 0.4,
	"Base.FF_Boots_Leather_Short", 0.4,
	"Base.FF_Boots_Cowboy", 0.4,
	"Base.FF_Boots_Cowboy_Plain", 0.4,
	"Base.FF_Shoe_Boots_Ankle", 0.4,
	"Base.FF_Shoe_Boots_Ankle_Steel", 0.4,
	"Base.FF_Boots_Common", 0.4,
	"Base.FF_Shoe_Common", 0.4,
	"Base.FF_Shoe_Trainers", 0.4,
	"Base.FF_Shoe_TrainersBlack", 0.4,
	"Base.FF_Shoe_TrainersWhite", 0.4,
	"Base.FF_Boots_Platform_Thighhigh", 0.4,
	"Base.FF_Boots_Platform_Kneehigher", 0.4,
	"Base.FF_Boots_Platform_Kneehigh", 0.4,
	"Base.FF_Boots_Platform_Ankle", 0.4,
	"Base.FF_Boots_Platform_AnkleLow", 0.4,
	"Base.FF_Boots_PlatformPunk_Thighhigh", 0.4,
	"Base.FF_Boots_PlatformPunk_Kneehigher", 0.4,
	"Base.FF_Boots_PlatformPunk_Kneehigh", 0.4,
	"Base.FF_Boots_Pointy_AnkleLow", 0.4,
	"Base.FF_Boots_Pointy_Ankle", 0.4,
	"Base.FF_Boots_Pointy_Kneehigh", 0.4,
	"Base.FF_Boots_PointySkull_AnkleLow", 0.4,
	"Base.FF_Boots_PointySkull_Kneehigh", 0.4,
	"Base.FF_BootsRE_Leather_DwarfHeel", 0.4,
	"Base.FF_BootsRE_Leather_Heel", 0.4,
	"Base.FF_BootsRE_Leather_ThighhighHeel", 0.4,
	"Base.FF_BootsRE_Leather_KneehighHeel", 0.4,
	"Base.FF_Boots_Military_Thighhigh", 0.4,
	"Base.FF_Boots_Military_Kneehigher", 0.4,
	"Base.FF_Boots_Military_Kneehigh", 0.4,
	"Base.FF_Boots_Military_Ankle", 0.4,
	"Base.Belt_Generic",0.4,
	"Base.Belt_Cowboy",0.4,
	"Base.Belt_Gemstone",0.4,
	"Base.Belt_Gold",0.4,
	"Base.Belt_Silver",0.4,
	"Base.BeltLarge_Skulls",0.4,
	"Base.BeltLarge",0.4,
	"Base.BeltLarge_Gemstone",0.4,
	"Base.BeltLarge_Star",0.4,
	"Base.BeltLarge_Letters",0.4,
	"Base.BeltLargeFur",0.4,
	"Base.Accessory_Wild_Rag",0.4,
	"Base.Accessory_Wild_Rag_Bandana",0.4,
	"Base.Accessory_Wild_Rag_Scarf",0.4,
	"Base.Accessory_Tie_Bolo",0.4,
	"Base.Accessory_Tie_Bolo_Letters",0.4,
	"Base.Accessory_Tie_Bolo_Star",0.4,
	"Base.Accessory_Tie_Bolo_Sun",0.4,
	"Base.Accessory_Tie_Bolo_Moon",0.4
)

BatchRuleInjection("Locker",
	"Base.Denim_Jacket_Cropped", 0.75,
	"Base.Denim_Jacket", 0.75,
	"Base.Denim_Jacket_O", 0.75,
	"Base.Denim_JacketReinforced", 2,
	"Base.Denim_JacketReinforced_O", 2,
	"Base.Denim_JacketShort", 0.75,
	"Base.Denim_JacketShort_O", 0.75,
	"Base.Denim_VestJacket", 0.75,
	"Base.Denim_VestJacket_O", 0.75,
	"Base.Denim_VestJacketCropped", 0.75,
	"Base.Denim_VestJacketCropped_O", 0.75,
	"Base.Denim_VestJacketShort", 0.75,
	"Base.Denim_VestJacketShort_O", 0.75,
	"Base.Denim_LongCoat", 0.75,
	"Base.Denim_LongCoat_O", 0.75,
	"Base.Denim_LongCoatShort", 0.75,
	"Base.Denim_LongCoatShort_O", 0.75,
	"Base.Denim_LongCoatShort_Reinforced", 0.75,
	"Base.Denim_LongCoatShort_Reinforced_O", 0.75,
	"Base.Denim_LongCoatShortSleeveless", 0.75,
	"Base.Denim_LongCoatShortSleeveless_O", 0.75,
	"Base.Denim_TrenchCoat_Long_O", 0.75,
	"Base.Denim_TrenchCoat_Short_O", 0.75,
	"Base.TannedLeather_Jacket_Cropped", 0.75,
	"Base.TannedLeather_LongestCoat", 0.75,
	"Base.TannedLeather_LongestCoat_O", 0.75,
	"Base.TannedLeather_LongerCoat", 0.75,
	"Base.TannedLeather_LongerCoat_O", 0.75,
	"Base.TannedLeather_LongCoat", 0.75,
	"Base.TannedLeather_LongCoat_O", 0.75,
	"Base.TannedLeather_Jacket", 0.75,
	"Base.TannedLeather_Jacket_O", 0.75,
	"Base.TannedLeather_Jacket_MidLength", 0.75,
	"Base.TannedLeather_Jacket_MidLength_O", 0.75,
	"Base.TannedLeather_TrenchCoat_Long_O", 0.75,
	"Base.TannedLeather_TrenchCoat_Short_O", 0.75,
	"Base.TannedLeather_LongestCoat_Winter", 0.75,
	"Base.TannedLeather_LongestCoat_Winter_O", 0.75,
	"Base.TannedLeather_LongerCoat_Winter", 0.75,
	"Base.TannedLeather_LongerCoat_Winter_O", 0.75,
	"Base.Cotton_LongestCoat_VintageMil", 0.75,	
	"Base.Cotton_LongestCoat_VintageMil_O", 1
)

BatchRuleInjection("SchoolLockers",
	"Base.Denim_Jacket_Cropped", 0.75,
	"Base.Denim_Jacket", 0.75,
	"Base.Denim_Jacket_O", 0.75,
	"Base.Denim_JacketReinforced", 2,
	"Base.Denim_JacketReinforced_O", 2,
	"Base.Denim_JacketShort", 0.75,
	"Base.Denim_JacketShort_O", 0.75,
	"Base.Denim_VestJacket", 0.75,
	"Base.Denim_VestJacket_O", 0.75,
	"Base.Denim_VestJacketCropped", 0.75,
	"Base.Denim_VestJacketCropped_O", 0.75,
	"Base.Denim_VestJacketShort", 0.75,
	"Base.Denim_VestJacketShort_O", 0.75,
	"Base.Denim_LongCoat", 0.3,
	"Base.Denim_LongCoat_O", 0.3,
	"Base.Denim_LongCoatShort", 0.3,
	"Base.Denim_LongCoatShort_O", 0.3,
	"Base.Denim_LongCoatShort_Reinforced", 0.3,
	"Base.Denim_LongCoatShort_Reinforced_O", 0.3,
	"Base.Denim_LongCoatShortSleeveless", 0.3,
	"Base.Denim_LongCoatShortSleeveless_O", 0.3,
	"Base.Denim_TrenchCoat_Long_O", 0.3,
	"Base.Denim_TrenchCoat_Short_O", 0.3,
	"Base.TannedLeather_Jacket_Cropped", 0.3,
	"Base.TannedLeather_LongestCoat", 0.3,
	"Base.TannedLeather_LongestCoat_O", 0.3,
	"Base.TannedLeather_LongerCoat", 0.3,
	"Base.TannedLeather_LongerCoat_O", 0.3,
	"Base.TannedLeather_LongCoat", 0.3,
	"Base.TannedLeather_LongCoat_O", 0.3,
	"Base.TannedLeather_Jacket", 0.3,
	"Base.TannedLeather_Jacket_O", 0.3,
	"Base.TannedLeather_Jacket_MidLength", 0.3,
	"Base.TannedLeather_Jacket_MidLength_O", 0.3,
	"Base.TannedLeather_TrenchCoat_Long_O", 0.3,
	"Base.TannedLeather_TrenchCoat_Short_O", 0.3,
	"Base.TannedLeather_LongestCoat_Winter", 0.3,
	"Base.TannedLeather_LongestCoat_Winter_O", 0.3,
	"Base.TannedLeather_LongerCoat_Winter", 0.3,
	"Base.TannedLeather_LongerCoat_Winter_O", 0.3,
	"Base.Cotton_LongestCoat_VintageMil", 0.3
)

BatchRuleInjection("FactoryLockers",
	"Base.Denim_Jacket_Cropped", 0.75,
	"Base.Denim_Jacket", 0.75,
	"Base.Denim_Jacket_O", 0.75,
	"Base.Denim_JacketReinforced", 2,
	"Base.Denim_JacketReinforced_O", 2,
	"Base.Denim_JacketShort", 0.75,
	"Base.Denim_JacketShort_O", 0.75,
	"Base.Denim_VestJacket", 0.75,
	"Base.Denim_VestJacket_O", 0.75,
	"Base.Denim_VestJacketCropped", 0.75,
	"Base.Denim_VestJacketCropped_O", 0.75,
	"Base.Denim_VestJacketShort", 0.75,
	"Base.Denim_VestJacketShort_O", 0.75,
	"Base.Denim_LongCoat", 0.75,
	"Base.Denim_LongCoat_O", 0.75,
	"Base.Denim_LongCoatShort", 0.75,
	"Base.Denim_LongCoatShort_O", 0.75,
	"Base.Denim_LongCoatShort_Reinforced", 0.75,
	"Base.Denim_LongCoatShort_Reinforced_O", 0.75,
	"Base.Denim_LongCoatShortSleeveless", 0.75,
	"Base.Denim_LongCoatShortSleeveless_O", 0.75,
	"Base.Denim_TrenchCoat_Long_O", 0.75,
	"Base.Denim_TrenchCoat_Short_O", 0.75,
	"Base.TannedLeather_Jacket_Cropped", 0.75,
	"Base.TannedLeather_LongestCoat", 0.75,
	"Base.TannedLeather_LongestCoat_O", 0.75,
	"Base.TannedLeather_LongerCoat", 0.75,
	"Base.TannedLeather_LongerCoat_O", 0.75,
	"Base.TannedLeather_LongCoat", 0.75,
	"Base.TannedLeather_LongCoat_O", 0.75,
	"Base.TannedLeather_Jacket", 0.75,
	"Base.TannedLeather_Jacket_O", 0.75,
	"Base.TannedLeather_Jacket_MidLength", 0.75,
	"Base.TannedLeather_Jacket_MidLength_O", 0.75,
	"Base.TannedLeather_TrenchCoat_Long_O", 0.75,
	"Base.TannedLeather_TrenchCoat_Short_O", 0.75,
	"Base.TannedLeather_LongestCoat_Winter", 0.75,
	"Base.TannedLeather_LongestCoat_Winter_O", 0.75,
	"Base.TannedLeather_LongerCoat_Winter", 0.75,
	"Base.TannedLeather_LongerCoat_Winter_O", 0.75,
	"Base.Cotton_LongestCoat_VintageMil", 0.75,	
	"Base.Cotton_LongestCoat_VintageMil_O", 0.75,
    "Base.Lumberjack_Shirt_10", 4,
    "Base.Denim_Shirt_10", 3,
    "Base.Denim_Shorts_J", 0.4,
    "Base.Denim_Skirt_Short", 0.4
)
	
BatchRuleInjection("LivingRoomShelf",
    "Base.FF_Boots_HF_New", 0.05,
    "Base.FF_Boots_HF_New_Longest", 0.05,
    "Base.FF_Boots_HF_New_Longer", 0.05,
    "Base.FF_Boots_HF_New_Long", 0.05,
    "Base.FF_Boots_Leather", 0.05,
    "Base.FF_Boots_Leather_Short", 0.05,
    "Base.FF_Boots_Cowboy", 0.05,
    "Base.FF_Boots_Cowboy_Plain", 0.05,
    "Base.FF_Shoe_Boots_Ankle", 0.05,
    "Base.FF_Shoe_Boots_Ankle_Steel", 0.05,
    "Base.FF_Boots_Common", 0.05,
    "Base.FF_Boots_Platform_Thighhigh", 0.05,
    "Base.FF_Boots_Platform_Kneehigher", 0.05,
    "Base.FF_Boots_Platform_Kneehigh", 0.05,
    "Base.FF_Boots_Platform_Ankle", 0.05,
    "Base.FF_Boots_Platform_AnkleLow", 0.05,
    "Base.FF_Boots_Pointy_AnkleLow", 0.05,
    "Base.FF_Boots_Pointy_Ankle", 0.05,
    "Base.FF_Boots_Pointy_Kneehigh", 0.05,
	"Base.FF_Boots_HF_New", 0.05,
	"Base.FF_Boots_HF_New_Longest", 0.05,
	"Base.FF_Boots_HF_New_Longer", 0.05,
	"Base.FF_Boots_HF_New_Long", 0.05,
	"Base.FF_Shoe_Boots_Ankle_Platform", 0.05,
	"Base.FF_Boots_HighHeels", 0.05,
	"Base.FF_Shoe_Women", 0.05,
	"Base.FF_Shoe_Women_Platform", 0.05,
	"Base.FF_Shoe_Women_2", 0.05,
	"Base.FF_Shoe_Moccasin", 0.05,
	"Base.FF_Boots_UGG_DwarfHeel", 0.05,
	"Base.FF_Boots_UGG_Heel", 0.05,
	"Base.FF_Boots_UGG_ThighhighHeel", 0.05,
	"Base.FF_Boots_UGG_KneehighHeel", 0.05,
	"Base.FF_Boots_UGG", 0.05,
	"Base.FF_Boots_UGG_Thighhigh", 0.05,
	"Base.FF_Boots_UGG_Kneehigh", 0.05,
	"Base.FF_Boots_Leather", 0.05,
	"Base.FF_Boots_Leather_Short", 0.05,
	"Base.FF_Boots_Cowboy", 0.05,
	"Base.FF_Boots_Cowboy_Plain", 0.05,
	"Base.FF_Shoe_Boots_Ankle", 0.05,
	"Base.FF_Shoe_Boots_Ankle_Steel", 0.05,
	"Base.FF_Boots_Common", 0.05,
	"Base.FF_Shoe_Common", 0.05,
	"Base.FF_Shoe_Trainers", 0.05,
	"Base.FF_Shoe_TrainersBlack", 0.05,
	"Base.FF_Shoe_TrainersWhite", 0.05,
	"Base.FF_Boots_Platform_Thighhigh", 0.05,
	"Base.FF_Boots_Platform_Kneehigher", 0.05,
	"Base.FF_Boots_Platform_Kneehigh", 0.05,
	"Base.FF_Boots_Platform_Ankle", 0.05,
	"Base.FF_Boots_Platform_AnkleLow", 0.05,
	"Base.FF_Boots_PlatformPunk_Thighhigh", 0.05,
	"Base.FF_Boots_PlatformPunk_Kneehigher", 0.05,
	"Base.FF_Boots_PlatformPunk_Kneehigh", 0.05,
	"Base.FF_Boots_Pointy_AnkleLow", 0.05,
	"Base.FF_Boots_Pointy_Ankle", 0.05,
	"Base.FF_Boots_Pointy_Kneehigh", 0.05,
	"Base.FF_Boots_PointySkull_AnkleLow", 0.05,
	"Base.FF_Boots_PointySkull_Kneehigh", 0.05,
	"Base.FF_BootsRE_Leather_DwarfHeel", 0.05,
	"Base.FF_BootsRE_Leather_Heel", 0.05,
	"Base.FF_BootsRE_Leather_ThighhighHeel", 0.05,
	"Base.FF_BootsRE_Leather_KneehighHeel", 0.05,
	"Base.FF_Boots_Military_Thighhigh", 0.05,
	"Base.FF_Boots_Military_Kneehigher", 0.05,
	"Base.FF_Boots_Military_Kneehigh", 0.05,
	"Base.FF_Boots_Military_Ankle", 0.05
)

BatchRuleInjection("CrateClothesRandom",
    "Base.FF_Boots_HF_New", 2,
    "Base.FF_Boots_HF_New_Longest", 2,
    "Base.FF_Boots_HF_New_Longer", 2,
    "Base.FF_Boots_HF_New_Long", 2,
    "Base.FF_Boots_Leather", 2,
    "Base.FF_Boots_Leather_Short", 2,
    "Base.FF_Boots_Cowboy", 2,
    "Base.FF_Boots_Cowboy_Plain", 2,
    "Base.FF_Shoe_Boots_Ankle", 2,
    "Base.FF_Shoe_Boots_Ankle_Steel", 2,
    "Base.FF_Boots_Common", 2,
    "Base.FF_Boots_Platform_Thighhigh", 2,
    "Base.FF_Boots_Platform_Kneehigher", 2,
    "Base.FF_Boots_Platform_Kneehigh", 2,
    "Base.FF_Boots_Platform_Ankle", 2,
    "Base.FF_Boots_Platform_AnkleLow", 2,
    "Base.FF_Boots_Pointy_AnkleLow", 2,
    "Base.FF_Boots_Pointy_Ankle", 2,
    "Base.FF_Boots_Pointy_Kneehigh", 2,
	"Base.FF_Boots_HF_New", 2,
	"Base.FF_Boots_HF_New_Longest", 2,
	"Base.FF_Boots_HF_New_Longer", 2,
	"Base.FF_Boots_HF_New_Long", 2,
	"Base.FF_Shoe_Boots_Ankle_Platform", 2,
	"Base.FF_Boots_HighHeels", 2,
	"Base.FF_Shoe_Women", 2,
	"Base.FF_Shoe_Women_Platform", 2,
	"Base.FF_Shoe_Women_2", 2,
	"Base.FF_Shoe_Moccasin", 2,
	"Base.FF_Boots_UGG_DwarfHeel", 2,
	"Base.FF_Boots_UGG_Heel", 2,
	"Base.FF_Boots_UGG_ThighhighHeel", 2,
	"Base.FF_Boots_UGG_KneehighHeel", 2,
	"Base.FF_Boots_UGG", 2,
	"Base.FF_Boots_UGG_Thighhigh", 2,
	"Base.FF_Boots_UGG_Kneehigh", 2,
	"Base.FF_Boots_Leather", 2,
	"Base.FF_Boots_Leather_Short", 2,
	"Base.FF_Boots_Cowboy", 2,
	"Base.FF_Boots_Cowboy_Plain", 2,
	"Base.FF_Shoe_Boots_Ankle", 2,
	"Base.FF_Shoe_Boots_Ankle_Steel", 2,
	"Base.FF_Boots_Common", 2,
	"Base.FF_Shoe_Common", 2,
	"Base.FF_Shoe_Trainers", 2,
	"Base.FF_Shoe_TrainersBlack", 2,
	"Base.FF_Shoe_TrainersWhite", 2,
	"Base.FF_Boots_Platform_Thighhigh", 2,
	"Base.FF_Boots_Platform_Kneehigher", 2,
	"Base.FF_Boots_Platform_Kneehigh", 2,
	"Base.FF_Boots_Platform_Ankle", 2,
	"Base.FF_Boots_Platform_AnkleLow", 2,
	"Base.FF_Boots_PlatformPunk_Thighhigh", 2,
	"Base.FF_Boots_PlatformPunk_Kneehigher", 2,
	"Base.FF_Boots_PlatformPunk_Kneehigh", 2,
	"Base.FF_Boots_Pointy_AnkleLow", 2,
	"Base.FF_Boots_Pointy_Ankle", 2,
	"Base.FF_Boots_Pointy_Kneehigh", 2,
	"Base.FF_Boots_PointySkull_AnkleLow", 2,
	"Base.FF_Boots_PointySkull_Kneehigh", 2,
	"Base.FF_BootsRE_Leather_DwarfHeel", 2,
	"Base.FF_BootsRE_Leather_Heel", 2,
	"Base.FF_BootsRE_Leather_ThighhighHeel", 2,
	"Base.FF_BootsRE_Leather_KneehighHeel", 2,
	"Base.FF_Boots_Military_Thighhigh", 2,
	"Base.FF_Boots_Military_Kneehigher", 2,
	"Base.FF_Boots_Military_Kneehigh", 2,
	"Base.FF_Boots_Military_Ankle", 2
)

BatchRuleInjection("CrateClothesRandom",
	"Base.Cotton_LongestCoat_VintageMil", 0.4,	
	"Base.Cotton_LongestCoat_VintageMil_O", 0.4,	
	"Base.Cotton_Blouse", 0.4,
	"Base.Cotton_Blouse_V", 0.4,
	"Base.Cotton_Blouse_V_Cropped", 0.4,	
	"Base.Cotton_Blouse_V_Cropped_Tiny", 0.4,
	"Base.Lumberjack_Shirt_10", 0.4,
	"Base.Lumberjack_Shirt_11", 0.4,
	"Base.Lumberjack_Shirt_12", 0.4,
	"Base.Lumberjack_Shirt_15", 0.4,
	"Base.Lumberjack_Shirt_20", 0.4,
	"Base.Lumberjack_Shirt_21", 0.4,
	"Base.Lumberjack_Shirt_22", 0.4,
	"Base.Lumberjack_Shirt_25", 0.4,
	"Base.Lumberjack_Cropped_Shirt_10", 0.4,
	"Base.Lumberjack_Cropped_Shirt_11", 0.4,
	"Base.Lumberjack_Cropped_Shirt_12", 0.4,
	"Base.Lumberjack_Cropped_Shirt_15", 0.4,
	"Base.Lumberjack_Cropped_Shirt_20", 0.4,
	"Base.Lumberjack_Cropped_Shirt_21", 0.4,
	"Base.Lumberjack_Cropped_Shirt_22", 0.4,
	"Base.Lumberjack_Cropped_Shirt_25", 0.4,
	"Base.Lumberjack_Sleeveless_Shirt_10", 0.4,
	"Base.Lumberjack_Sleeveless_Shirt_11", 0.4,
	"Base.Lumberjack_Sleeveless_Shirt_12", 0.4,
	"Base.Lumberjack_Sleeveless_Shirt_15", 0.4,
	"Base.Denim_Bandeau", 0.4,
	"Base.Denim_Bandeau_Tiny", 0.4,
	"Base.Denim_Top", 0.4
)

BatchRuleInjection("CrateClothesRandom",
	"Base.Denim_CropTop", 0.4,
	"Base.Denim_Skirt_Short", 0.4,
	"Base.Denim_Skirt_Short_LW", 0.4,
	"Base.Denim_Skirt_Longer", 0.4,
	"Base.Denim_Skirt_Long", 0.4,
	"Base.Denim_Skirt_Mesh_HW", 0.4,
	"Base.Denim_Skirt_Mesh_LW", 0.4,
	"Base.Denim_SkirtPleated", 0.4,
	"Base.Denim_SkirtPleated_Frilled", 0.4,
	"Base.Mesh_Denim_Skirt_Longer", 0.4,
	"Base.Denim_Jacket_Cropped", 0.4,
	"Base.Denim_Jacket", 0.4,
	"Base.Denim_Jacket_O", 0.4,
	"Base.Denim_JacketReinforced", 0.4,
	"Base.Denim_JacketReinforced_O", 0.4,
	"Base.Denim_JacketShort", 0.4,
	"Base.Denim_JacketShort_O", 0.4,
	"Base.Denim_VestJacket", 0.4,
	"Base.Denim_VestJacket_O", 0.4,
	"Base.Denim_VestJacketCropped", 0.4,
	"Base.Denim_VestJacketCropped_O", 0.4,
	"Base.Denim_VestJacketShort", 0.4,
	"Base.Denim_VestJacketShort_O", 0.4,
	"Base.Denim_LongCoat", 0.4,
	"Base.Denim_LongCoat_O", 0.4,
	"Base.Denim_LongCoatShort", 0.4,
	"Base.Denim_LongCoatShort_O", 0.4,
	"Base.Denim_LongCoatShort_Reinforced", 0.4,
	"Base.Denim_LongCoatShort_Reinforced_O", 0.4,
	"Base.Denim_LongCoatShortSleeveless", 0.4,
	"Base.Denim_LongCoatShortSleeveless_O", 0.4,
	"Base.Denim_TrenchCoat_Long_O", 0.4,
	"Base.Denim_TrenchCoat_Short_O", 0.4,
	"Base.Mesh_Denim_Pants", 0.4,
	"Base.Mesh_Denim_PantsFlared", 0.4,
	"Base.Mesh_Denim_PantsChaps", 0.4,
	"Base.Mesh_Denim_LongShorts", 0.4,
	"Base.Skin_Denim_Pants_High", 0.4,
	"Base.Skin_Denim_Pants_J", 0.4,
	"Base.Skin_Denim_Pants_Low", 0.4,
	"Base.Skin_Denim_Pants_Lower", 0.4,
	"Base.Skin_Denim_Pants_V", 0.4,
	"Base.Mesh_Denim_Shorts", 0.4,
	"Base.Mesh_Denim_ShortShorts", 0.4,
	"Base.Mesh_Denim_ShorterShorts", 0.4,
	"Base.Skin_Denim_Shorts", 0.4,
	"Base.Denim_Shorts_High", 0.4,
	"Base.Denim_Shorts_J", 0.4,
	"Base.Denim_Shorts_Low", 0.4,
	"Base.Denim_Shorts_Lower", 0.4,
	"Base.Denim_Shorts_V", 0.4,
	"Base.Denim_Overshirt", 0.4,
	"Base.Denim_Overshirt_O", 0.4,
	"Base.Denim_Shirt_10", 0.4,
	"Base.Denim_Shirt_11", 0.4,
	"Base.Denim_Shirt_12", 0.4,
	"Base.Denim_Shirt_15", 0.4,
	"Base.Denim_Shirt_20", 0.4,
	"Base.Denim_Shirt_21", 0.4,
	"Base.Denim_Shirt_22", 0.4,
	"Base.Denim_Shirt_25", 0.4,
	"Base.Denim_Sleeveless_Shirt_10", 0.4,
	"Base.Denim_Sleeveless_Shirt_11", 0.4
)

BatchRuleInjection("CrateClothesRandom",
	"Base.Denim_Sleeveless_Shirt_12", 0.4,
	"Base.Denim_Sleeveless_Shirt_15", 0.4,
	"Base.FurCoat_Fur", 0.4,
	"Base.FurJacketShort", 0.4,
	"Base.FurJacketShort_O", 0.4,
	"Base.Belt_Generic", 0.4,
	"Base.Belt_Cowboy", 0.4,
	"Base.Belt_Gemstone", 0.4,
	"Base.Belt_Gold", 0.4,
	"Base.Belt_Silver", 0.4,
	"Base.BeltLarge_Skulls", 0.4,
	"Base.BeltLarge", 0.4,
	"Base.BeltLarge_Gemstone", 0.4,
	"Base.BeltLarge_Star", 0.4,
	"Base.BeltLarge_Letters", 0.4,
	"Base.BeltLargeFur", 0.4,
	"Base.Accessory_Wild_Rag", 0.4,
	"Base.Accessory_Wild_Rag_Bandana", 0.4,
	"Base.Accessory_Wild_Rag_Scarf", 0.4,
	"Base.Accessory_Tie_Bolo_NoCollar", 0.4,
	"Base.Accessory_Tie_Bolo_Letters_NoCollar", 0.4,
	"Base.Accessory_Tie_Bolo_Star_NoCollar", 0.4,
	"Base.Accessory_Tie_Bolo_Sun_NoCollar", 0.4,
	"Base.Accessory_Tie_Bolo_Moon_NoCollar", 0.4,
	"Base.Accessory_Tie_Bolo", 0.4,
	"Base.Accessory_Tie_Bolo_Letters", 0.4,
	"Base.Accessory_Tie_Bolo_Star", 0.4,
	"Base.Accessory_Tie_Bolo_Sun", 0.4,
	"Base.Accessory_Tie_Bolo_Moon", 0.4,
	"Base.FF_Boots_HF_New", 0.4,
	"Base.FF_Boots_HF_New_Longest", 0.4,
	"Base.FF_Boots_HF_New_Longer", 0.4,
	"Base.FF_Boots_HF_New_Long", 0.4,
	"Base.FF_Shoe_Boots_Ankle_Platform", 0.4,
	"Base.FF_Boots_HighHeels", 0.4,
	"Base.FF_Shoe_Women", 0.4,
	"Base.FF_Shoe_Women_Platform", 0.4,
	"Base.FF_Shoe_Women_2", 0.4,
	"Base.FF_Shoe_Moccasin", 0.4
)

BatchRuleInjection("CrateClothesRandom",
	"Base.FF_Boots_UGG_DwarfHeel", 0.4,
	"Base.FF_Boots_UGG_Heel", 0.4,
	"Base.FF_Boots_UGG_ThighhighHeel", 0.4,
	"Base.FF_Boots_UGG_KneehighHeel", 0.4,
	"Base.FF_Boots_UGG", 0.4,
	"Base.FF_Boots_UGG_Thighhigh", 0.4,
	"Base.FF_Boots_UGG_Kneehigh", 0.4,
	"Base.FF_Boots_Leather", 0.4,
	"Base.FF_Boots_Leather_Short", 0.4,
	"Base.FF_Boots_Cowboy", 0.4,
	"Base.FF_Boots_Cowboy_Plain", 0.4,
	"Base.FF_Shoe_Boots_Ankle", 0.4,
	"Base.FF_Shoe_Boots_Ankle_Steel", 0.4,
	"Base.FF_Boots_Common", 0.4,
	"Base.FF_Shoe_Common", 0.4,
	"Base.FF_Shoe_Trainers", 0.4,
	"Base.FF_Shoe_TrainersBlack", 0.4,
	"Base.FF_Shoe_TrainersWhite", 0.4,
	"Base.FF_Boots_Platform_Thighhigh", 0.4,
	"Base.FF_Boots_Platform_Kneehigher", 0.4,
	"Base.FF_Boots_Platform_Kneehigh", 0.4,
	"Base.FF_Boots_Platform_Ankle", 0.4,
	"Base.FF_Boots_Platform_AnkleLow", 0.4,
	"Base.FF_Boots_PlatformPunk_Thighhigh", 0.4,
	"Base.FF_Boots_PlatformPunk_Kneehigher", 0.4,
	"Base.FF_Boots_PlatformPunk_Kneehigh", 0.4,
	"Base.FF_Boots_Pointy_AnkleLow", 0.4,
	"Base.FF_Boots_Pointy_Ankle", 0.4,
	"Base.FF_Boots_Pointy_Kneehigh", 0.4,
	"Base.FF_Boots_PointySkull_AnkleLow", 0.4,
	"Base.FF_Boots_PointySkull_Kneehigh", 0.4,
	"Base.FF_BootsRE_Leather_DwarfHeel", 0.4,
	"Base.FF_BootsRE_Leather_Heel", 0.4,
	"Base.FF_BootsRE_Leather_ThighhighHeel", 0.4,
	"Base.FF_BootsRE_Leather_KneehighHeel", 0.4,
	"Base.FF_Boots_Military_Thighhigh", 0.4,
	"Base.FF_Boots_Military_Kneehigher", 0.4,
	"Base.FF_Boots_Military_Kneehigh", 0.4,
	"Base.FF_Boots_Military_Ankle", 0.4,
	"Base.TannedLeather_Jacket_Cropped", 0.4,
	"Base.TannedLeather_LongestCoat", 0.4,
	"Base.TannedLeather_LongestCoat_O", 0.4,
	"Base.TannedLeather_LongerCoat", 0.4,
	"Base.TannedLeather_LongerCoat_O", 0.4
)

BatchRuleInjection("CrateClothesRandom",
	"Base.TannedLeather_LongCoat", 0.4,
	"Base.TannedLeather_LongCoat_O", 0.4,
	"Base.TannedLeather_Jacket", 0.4,
	"Base.TannedLeather_Jacket_O", 0.4,
	"Base.TannedLeather_Jacket_MidLength", 0.4,
	"Base.TannedLeather_Jacket_MidLength_O", 0.4,
	"Base.TannedLeather_TrenchCoat_Long_O", 0.4,
	"Base.TannedLeather_TrenchCoat_Short_O", 0.4,
	"Base.TannedLeather_LongestCoat_Winter", 0.4,
	"Base.TannedLeather_LongestCoat_Winter_O", 0.4,
	"Base.TannedLeather_LongerCoat_Winter", 0.4,
	"Base.TannedLeather_LongerCoat_Winter_O", 0.4,
	"Base.TannedLeather_Top", 0.4,
	"Base.TannedLeather_TopSkimpy", 0.4,
	"Base.TannedLeather_CropTop", 0.4,
	"Base.TannedLeather_Bandeau", 0.4,
	"Base.TannedLeather_Bandeau_Tiny", 0.4,
	"Base.TannedLeather_Corset", 0.4,
	"Base.TannedLeather_Corset_OuterLayer", 0.4,
	"Base.TannedLeather_Corset_UB", 0.4,
	"Base.TannedLeather_Corset_UB_OuterLayer", 0.4,
	"Base.TannedLeather_Corset_Strap", 0.4,
	"Base.TannedLeather_Corset_Strap_OuterLayer", 0.4,
	"Base.TannedLeather_Corset_UB_Strap", 0.4,
	"Base.TannedLeather_Corset_UB_Strap_OuterLayer", 0.4,
	"Base.TannedLeather_WaistCoat", 0.4,
	"Base.TannedLeather_WaistCoat_O", 0.4,
	"Base.TMesh_TannedLeather_Pants", 0.4,
	"Base.TMesh_TannedLeather_LongShorts", 0.4,
	"Base.TMesh_TannedLeather_Shorts", 0.4,
	"Base.TMesh_TannedLeather_ShortShorts", 0.4,
	"Base.TMesh_TannedLeather_ShorterShorts", 0.4,
	"Base.TannedLeather_Leotard", 0.4,
	"Base.TannedLeather_Leotard_MC", 0.4,
	"Base.TannedLeather_Leotard_HC", 0.4,
	"Base.TannedLeather_LeotardUB", 0.4,
	"Base.TannedLeather_LeotardUB_MC", 0.4,
	"Base.TannedLeather_LeotardUB_HC", 0.4,
	"Base.TSkin_TannedLeather_Pants_High", 0.4,
	"Base.TSkin_TannedLeather_Pants", 0.4
)

BatchRuleInjection("CrateClothesRandom",
	"Base.TSkin_TannedLeather_Pants_Low", 0.4,
	"Base.TSkin_TannedLeather_Pants_Lower", 0.4,
	"Base.TSkin_TannedLeather_Pants_V", 0.4,
	"Base.TannedLeather_Shorts_High", 0.4,
	"Base.TannedLeather_Shorts_J", 0.4,
	"Base.TannedLeather_Shorts_Low", 0.4,
	"Base.TannedLeather_Shorts_Lower", 0.4,
	"Base.TannedLeather_Shorts_V", 0.4,
	"Base.TannedLeather_Skirt_Mesh_HW", 0.4,
	"Base.TannedLeather_Skirt_Mesh_LW", 0.4,
	"Base.TannedLeather_Skirt_Mesh_LerW", 0.4,
	"Base.TannedLeather_Skirt_MeshFrilled_HW", 0.4,
	"Base.TannedLeather_Skirt_MeshFrilled_LW", 0.4,
	"Base.TannedLeather_Skirt_MeshFrilled_LerW", 0.4,
	"Base.TannedLeather_SkirtMicro_Mesh", 0.4,
	"Base.TannedLeather_SkirtMicro_MeshFrilled", 0.4,
	"Base.TannedLeather_Long_Skirt", 0.4,
	"Base.TannedLeather_Skirt_Mid", 0.4,
	"Base.TannedLeather_Skirt_Short", 0.4,
	"Base.TannedLeather_Skirt_Shorter", 0.4,
	"Base.TannedLeather_Loincloth", 0.4,
	"Base.Armour_PouchStrap", 0.4,
	"Base.Armour_Faulds", 0.4,
	"Base.Armour_Faulds_Short", 0.4,
	"Base.Armour_ShoulderPad_R", 0.4,
	"Base.Armour_ShoulderPad_L", 0.4,
	"Base.Armour_Armguards_R", 0.4,
	"Base.Armour_Armguards_L", 0.4,
	"Base.Armour_ArmguardsLong_R", 0.4,
	"Base.Armour_ArmguardsLong_L", 0.4,
	"Base.TannedLeather_SleevesLeg_L", 0.4,
	"Base.TannedLeather_SleevesLeg_R", 0.4,
	"Base.TannedLeather_Sleeves_L", 0.4,
	"Base.TannedLeather_Sleeves_R", 0.4,
	"Base.Hat_Cowboy_Flat", 0.4
)

BatchRuleInjection("LaundryLoad1",
    "Base.FF_Boots_HF_New", 0.1,
    "Base.FF_Boots_HF_New_Longest", 0.1,
    "Base.FF_Boots_HF_New_Longer", 0.1,
    "Base.FF_Boots_HF_New_Long", 0.1,
    "Base.FF_Boots_Leather", 0.1,
    "Base.FF_Boots_Leather_Short", 0.1,
    "Base.FF_Boots_Cowboy", 0.1,
    "Base.FF_Boots_Cowboy_Plain", 0.1,
    "Base.FF_Shoe_Boots_Ankle", 0.1,
    "Base.FF_Shoe_Boots_Ankle_Steel", 0.1,
    "Base.FF_Boots_Common", 0.1,
    "Base.FF_Boots_Platform_Thighhigh", 0.1,
    "Base.FF_Boots_Platform_Kneehigher", 0.1,
    "Base.FF_Boots_Platform_Kneehigh", 0.1,
    "Base.FF_Boots_Platform_Ankle", 0.1,
    "Base.FF_Boots_Platform_AnkleLow", 0.1,
    "Base.FF_Boots_Pointy_AnkleLow", 0.1,
    "Base.FF_Boots_Pointy_Ankle", 0.1,
    "Base.FF_Boots_Pointy_Kneehigh", 0.1,
	"Base.FF_Boots_HF_New", 0.1,
	"Base.FF_Boots_HF_New_Longest", 0.1,
	"Base.FF_Boots_HF_New_Longer", 0.1,
	"Base.FF_Boots_HF_New_Long", 0.1,
	"Base.FF_Shoe_Boots_Ankle_Platform", 0.1,
	"Base.FF_Boots_HighHeels", 0.1,
	"Base.FF_Shoe_Women", 0.1,
	"Base.FF_Shoe_Women_Platform", 0.1,
	"Base.FF_Shoe_Women_2", 0.1,
	"Base.FF_Shoe_Moccasin", 0.1,
	"Base.FF_Boots_UGG_DwarfHeel", 0.1,
	"Base.FF_Boots_UGG_Heel", 0.1,
	"Base.FF_Boots_UGG_ThighhighHeel", 0.1,
	"Base.FF_Boots_UGG_KneehighHeel", 0.1,
	"Base.FF_Boots_UGG", 0.1,
	"Base.FF_Boots_UGG_Thighhigh", 0.1,
	"Base.FF_Boots_UGG_Kneehigh", 0.1,
	"Base.FF_Boots_Leather", 0.1,
	"Base.FF_Boots_Leather_Short", 0.1,
	"Base.FF_Boots_Cowboy", 0.1,
	"Base.FF_Boots_Cowboy_Plain", 0.1,
	"Base.FF_Shoe_Boots_Ankle", 0.1,
	"Base.FF_Shoe_Boots_Ankle_Steel", 0.1,
	"Base.FF_Boots_Common", 0.1,
	"Base.FF_Shoe_Common", 0.1,
	"Base.FF_Shoe_Trainers", 0.1,
	"Base.FF_Shoe_TrainersBlack", 0.1,
	"Base.FF_Shoe_TrainersWhite", 0.1,
	"Base.FF_Boots_Platform_Thighhigh", 0.1,
	"Base.FF_Boots_Platform_Kneehigher", 0.1,
	"Base.FF_Boots_Platform_Kneehigh", 0.1,
	"Base.FF_Boots_Platform_Ankle", 0.1,
	"Base.FF_Boots_Platform_AnkleLow", 0.1,
	"Base.FF_Boots_PlatformPunk_Thighhigh", 0.1,
	"Base.FF_Boots_PlatformPunk_Kneehigher", 0.1,
	"Base.FF_Boots_PlatformPunk_Kneehigh", 0.1,
	"Base.FF_Boots_Pointy_AnkleLow", 0.1,
	"Base.FF_Boots_Pointy_Ankle", 0.1,
	"Base.FF_Boots_Pointy_Kneehigh", 0.1,
	"Base.FF_Boots_PointySkull_AnkleLow", 0.1,
	"Base.FF_Boots_PointySkull_Kneehigh", 0.1,
	"Base.FF_BootsRE_Leather_DwarfHeel", 0.1,
	"Base.FF_BootsRE_Leather_Heel", 0.1,
	"Base.FF_BootsRE_Leather_ThighhighHeel", 0.1,
	"Base.FF_BootsRE_Leather_KneehighHeel", 0.1,
	"Base.FF_Boots_Military_Thighhigh", 0.1,
	"Base.FF_Boots_Military_Kneehigher", 0.1,
	"Base.FF_Boots_Military_Kneehigh", 0.1,
	"Base.FF_Boots_Military_Ankle", 0.1
)

BatchRuleInjection("LaundryLoad3",
    "Base.FF_Boots_HF_New", 0.1,
    "Base.FF_Boots_HF_New_Longest", 0.1,
    "Base.FF_Boots_HF_New_Longer", 0.1,
    "Base.FF_Boots_HF_New_Long", 0.1,
    "Base.FF_Boots_Leather", 0.1,
    "Base.FF_Boots_Leather_Short", 0.1,
    "Base.FF_Boots_Cowboy", 0.1,
    "Base.FF_Boots_Cowboy_Plain", 0.1,
    "Base.FF_Shoe_Boots_Ankle", 0.1,
    "Base.FF_Shoe_Boots_Ankle_Steel", 0.1,
    "Base.FF_Boots_Common", 0.1,
    "Base.FF_Boots_Platform_Thighhigh", 0.1,
    "Base.FF_Boots_Platform_Kneehigher", 0.1,
    "Base.FF_Boots_Platform_Kneehigh", 0.1,
    "Base.FF_Boots_Platform_Ankle", 0.1,
    "Base.FF_Boots_Platform_AnkleLow", 0.1,
    "Base.FF_Boots_Pointy_AnkleLow", 0.1,
    "Base.FF_Boots_Pointy_Ankle", 0.1,
    "Base.FF_Boots_Pointy_Kneehigh", 0.1,
	"Base.FF_Boots_HF_New", 0.1,
	"Base.FF_Boots_HF_New_Longest", 0.1,
	"Base.FF_Boots_HF_New_Longer", 0.1,
	"Base.FF_Boots_HF_New_Long", 0.1,
	"Base.FF_Shoe_Boots_Ankle_Platform", 0.1,
	"Base.FF_Boots_HighHeels", 0.1,
	"Base.FF_Shoe_Women", 0.1,
	"Base.FF_Shoe_Women_Platform", 0.1,
	"Base.FF_Shoe_Women_2", 0.1,
	"Base.FF_Shoe_Moccasin", 0.1,
	"Base.FF_Boots_UGG_DwarfHeel", 0.1,
	"Base.FF_Boots_UGG_Heel", 0.1,
	"Base.FF_Boots_UGG_ThighhighHeel", 0.1,
	"Base.FF_Boots_UGG_KneehighHeel", 0.1,
	"Base.FF_Boots_UGG", 0.1,
	"Base.FF_Boots_UGG_Thighhigh", 0.1,
	"Base.FF_Boots_UGG_Kneehigh", 0.1,
	"Base.FF_Boots_Leather", 0.1,
	"Base.FF_Boots_Leather_Short", 0.1,
	"Base.FF_Boots_Cowboy", 0.1,
	"Base.FF_Boots_Cowboy_Plain", 0.1,
	"Base.FF_Shoe_Boots_Ankle", 0.1,
	"Base.FF_Shoe_Boots_Ankle_Steel", 0.1,
	"Base.FF_Boots_Common", 0.1,
	"Base.FF_Shoe_Common", 0.1,
	"Base.FF_Shoe_Trainers", 0.1,
	"Base.FF_Shoe_TrainersBlack", 0.1,
	"Base.FF_Shoe_TrainersWhite", 0.1,
	"Base.FF_Boots_Platform_Thighhigh", 0.1,
	"Base.FF_Boots_Platform_Kneehigher", 0.1,
	"Base.FF_Boots_Platform_Kneehigh", 0.1,
	"Base.FF_Boots_Platform_Ankle", 0.1,
	"Base.FF_Boots_Platform_AnkleLow", 0.1,
	"Base.FF_Boots_PlatformPunk_Thighhigh", 0.1,
	"Base.FF_Boots_PlatformPunk_Kneehigher", 0.1,
	"Base.FF_Boots_PlatformPunk_Kneehigh", 0.1,
	"Base.FF_Boots_Pointy_AnkleLow", 0.1,
	"Base.FF_Boots_Pointy_Ankle", 0.1,
	"Base.FF_Boots_Pointy_Kneehigh", 0.1,
	"Base.FF_Boots_PointySkull_AnkleLow", 0.1,
	"Base.FF_Boots_PointySkull_Kneehigh", 0.1,
	"Base.FF_BootsRE_Leather_DwarfHeel", 0.1,
	"Base.FF_BootsRE_Leather_Heel", 0.1,
	"Base.FF_BootsRE_Leather_ThighhighHeel", 0.1,
	"Base.FF_BootsRE_Leather_KneehighHeel", 0.1,
	"Base.FF_Boots_Military_Thighhigh", 0.1,
	"Base.FF_Boots_Military_Kneehigher", 0.1,
	"Base.FF_Boots_Military_Kneehigh", 0.1,
	"Base.FF_Boots_Military_Ankle", 0.1
)

BatchRuleInjection("LaundryLoad5",
    "Base.FF_Boots_HF_New", 0.1,
    "Base.FF_Boots_HF_New_Longest", 0.1,
    "Base.FF_Boots_HF_New_Longer", 0.1,
    "Base.FF_Boots_HF_New_Long", 0.1,
    "Base.FF_Boots_Leather", 0.1,
    "Base.FF_Boots_Leather_Short", 0.1,
    "Base.FF_Boots_Cowboy", 0.1,
    "Base.FF_Boots_Cowboy_Plain", 0.1,
    "Base.FF_Shoe_Boots_Ankle", 0.1,
    "Base.FF_Shoe_Boots_Ankle_Steel", 0.1,
    "Base.FF_Boots_Common", 0.1,
    "Base.FF_Boots_Platform_Thighhigh", 0.1,
    "Base.FF_Boots_Platform_Kneehigher", 0.1,
    "Base.FF_Boots_Platform_Kneehigh", 0.1,
    "Base.FF_Boots_Platform_Ankle", 0.1,
    "Base.FF_Boots_Platform_AnkleLow", 0.1,
    "Base.FF_Boots_Pointy_AnkleLow", 0.1,
    "Base.FF_Boots_Pointy_Ankle", 0.1,
    "Base.FF_Boots_Pointy_Kneehigh", 0.1,
	"Base.FF_Boots_HF_New", 0.1,
	"Base.FF_Boots_HF_New_Longest", 0.1,
	"Base.FF_Boots_HF_New_Longer", 0.1,
	"Base.FF_Boots_HF_New_Long", 0.1,
	"Base.FF_Shoe_Boots_Ankle_Platform", 0.1,
	"Base.FF_Boots_HighHeels", 0.1,
	"Base.FF_Shoe_Women", 0.1,
	"Base.FF_Shoe_Women_Platform", 0.1,
	"Base.FF_Shoe_Women_2", 0.1,
	"Base.FF_Shoe_Moccasin", 0.1,
	"Base.FF_Boots_UGG_DwarfHeel", 0.1,
	"Base.FF_Boots_UGG_Heel", 0.1,
	"Base.FF_Boots_UGG_ThighhighHeel", 0.1,
	"Base.FF_Boots_UGG_KneehighHeel", 0.1,
	"Base.FF_Boots_UGG", 0.1,
	"Base.FF_Boots_UGG_Thighhigh", 0.1,
	"Base.FF_Boots_UGG_Kneehigh", 0.1,
	"Base.FF_Boots_Leather", 0.1,
	"Base.FF_Boots_Leather_Short", 0.1,
	"Base.FF_Boots_Cowboy", 0.1,
	"Base.FF_Boots_Cowboy_Plain", 0.1,
	"Base.FF_Shoe_Boots_Ankle", 0.1,
	"Base.FF_Shoe_Boots_Ankle_Steel", 0.1,
	"Base.FF_Boots_Common", 0.1,
	"Base.FF_Shoe_Common", 0.1,
	"Base.FF_Shoe_Trainers", 0.1,
	"Base.FF_Shoe_TrainersBlack", 0.1,
	"Base.FF_Shoe_TrainersWhite", 0.1,
	"Base.FF_Boots_Platform_Thighhigh", 0.1,
	"Base.FF_Boots_Platform_Kneehigher", 0.1,
	"Base.FF_Boots_Platform_Kneehigh", 0.1,
	"Base.FF_Boots_Platform_Ankle", 0.1,
	"Base.FF_Boots_Platform_AnkleLow", 0.1,
	"Base.FF_Boots_PlatformPunk_Thighhigh", 0.1,
	"Base.FF_Boots_PlatformPunk_Kneehigher", 0.1,
	"Base.FF_Boots_PlatformPunk_Kneehigh", 0.1,
	"Base.FF_Boots_Pointy_AnkleLow", 0.1,
	"Base.FF_Boots_Pointy_Ankle", 0.1,
	"Base.FF_Boots_Pointy_Kneehigh", 0.1,
	"Base.FF_Boots_PointySkull_AnkleLow", 0.1,
	"Base.FF_Boots_PointySkull_Kneehigh", 0.1,
	"Base.FF_BootsRE_Leather_DwarfHeel", 0.1,
	"Base.FF_BootsRE_Leather_Heel", 0.1,
	"Base.FF_BootsRE_Leather_ThighhighHeel", 0.1,
	"Base.FF_BootsRE_Leather_KneehighHeel", 0.1,
	"Base.FF_Boots_Military_Thighhigh", 0.1,
	"Base.FF_Boots_Military_Kneehigher", 0.1,
	"Base.FF_Boots_Military_Kneehigh", 0.1,
	"Base.FF_Boots_Military_Ankle", 0.1
)

BatchRuleInjection("LaundryLoad7",
    "Base.FF_Boots_HF_New", 0.1,
    "Base.FF_Boots_HF_New_Longest", 0.1,
    "Base.FF_Boots_HF_New_Longer", 0.1,
    "Base.FF_Boots_HF_New_Long", 0.1,
    "Base.FF_Boots_Leather", 0.1,
    "Base.FF_Boots_Leather_Short", 0.1,
    "Base.FF_Boots_Cowboy", 0.1,
    "Base.FF_Boots_Cowboy_Plain", 0.1,
    "Base.FF_Shoe_Boots_Ankle", 0.1,
    "Base.FF_Shoe_Boots_Ankle_Steel", 0.1,
    "Base.FF_Boots_Common", 0.1,
    "Base.FF_Boots_Platform_Thighhigh", 0.1,
    "Base.FF_Boots_Platform_Kneehigher", 0.1,
    "Base.FF_Boots_Platform_Kneehigh", 0.1,
    "Base.FF_Boots_Platform_Ankle", 0.1,
    "Base.FF_Boots_Platform_AnkleLow", 0.1,
    "Base.FF_Boots_Pointy_AnkleLow", 0.1,
    "Base.FF_Boots_Pointy_Ankle", 0.1,
    "Base.FF_Boots_Pointy_Kneehigh", 0.1,
	"Base.FF_Boots_HF_New", 0.1,
	"Base.FF_Boots_HF_New_Longest", 0.1,
	"Base.FF_Boots_HF_New_Longer", 0.1,
	"Base.FF_Boots_HF_New_Long", 0.1,
	"Base.FF_Shoe_Boots_Ankle_Platform", 0.1,
	"Base.FF_Boots_HighHeels", 0.1,
	"Base.FF_Shoe_Women", 0.1,
	"Base.FF_Shoe_Women_Platform", 0.1,
	"Base.FF_Shoe_Women_2", 0.1,
	"Base.FF_Shoe_Moccasin", 0.1,
	"Base.FF_Boots_UGG_DwarfHeel", 0.1,
	"Base.FF_Boots_UGG_Heel", 0.1,
	"Base.FF_Boots_UGG_ThighhighHeel", 0.1,
	"Base.FF_Boots_UGG_KneehighHeel", 0.1,
	"Base.FF_Boots_UGG", 0.1,
	"Base.FF_Boots_UGG_Thighhigh", 0.1,
	"Base.FF_Boots_UGG_Kneehigh", 0.1,
	"Base.FF_Boots_Leather", 0.1,
	"Base.FF_Boots_Leather_Short", 0.1,
	"Base.FF_Boots_Cowboy", 0.1,
	"Base.FF_Boots_Cowboy_Plain", 0.1,
	"Base.FF_Shoe_Boots_Ankle", 0.1,
	"Base.FF_Shoe_Boots_Ankle_Steel", 0.1,
	"Base.FF_Boots_Common", 0.1,
	"Base.FF_Shoe_Common", 0.1,
	"Base.FF_Shoe_Trainers", 0.1,
	"Base.FF_Shoe_TrainersBlack", 0.1,
	"Base.FF_Shoe_TrainersWhite", 0.1,
	"Base.FF_Boots_Platform_Thighhigh", 0.1,
	"Base.FF_Boots_Platform_Kneehigher", 0.1,
	"Base.FF_Boots_Platform_Kneehigh", 0.1,
	"Base.FF_Boots_Platform_Ankle", 0.1,
	"Base.FF_Boots_Platform_AnkleLow", 0.1,
	"Base.FF_Boots_PlatformPunk_Thighhigh", 0.1,
	"Base.FF_Boots_PlatformPunk_Kneehigher", 0.1,
	"Base.FF_Boots_PlatformPunk_Kneehigh", 0.1,
	"Base.FF_Boots_Pointy_AnkleLow", 0.1,
	"Base.FF_Boots_Pointy_Ankle", 0.1,
	"Base.FF_Boots_Pointy_Kneehigh", 0.1,
	"Base.FF_Boots_PointySkull_AnkleLow", 0.1,
	"Base.FF_Boots_PointySkull_Kneehigh", 0.1,
	"Base.FF_BootsRE_Leather_DwarfHeel", 0.1,
	"Base.FF_BootsRE_Leather_Heel", 0.1,
	"Base.FF_BootsRE_Leather_ThighhighHeel", 0.1,
	"Base.FF_BootsRE_Leather_KneehighHeel", 0.1,
	"Base.FF_Boots_Military_Thighhigh", 0.1,
	"Base.FF_Boots_Military_Kneehigher", 0.1,
	"Base.FF_Boots_Military_Kneehigh", 0.1,
	"Base.FF_Boots_Military_Ankle", 0.1
)

BatchRuleInjection("DryerEmpty",
    "Base.FF_Boots_HF_New", 0.1,
    "Base.FF_Boots_HF_New_Longest", 0.1,
    "Base.FF_Boots_HF_New_Longer", 0.1,
    "Base.FF_Boots_HF_New_Long", 0.1,
    "Base.FF_Boots_Leather", 0.1,
    "Base.FF_Boots_Leather_Short", 0.1,
    "Base.FF_Boots_Cowboy", 0.1,
    "Base.FF_Boots_Cowboy_Plain", 0.1,
    "Base.FF_Shoe_Boots_Ankle", 0.1,
    "Base.FF_Shoe_Boots_Ankle_Steel", 0.1,
    "Base.FF_Boots_Common", 0.1,
    "Base.FF_Boots_Platform_Thighhigh", 0.1,
    "Base.FF_Boots_Platform_Kneehigher", 0.1,
    "Base.FF_Boots_Platform_Kneehigh", 0.1,
    "Base.FF_Boots_Platform_Ankle", 0.1,
    "Base.FF_Boots_Platform_AnkleLow", 0.1,
    "Base.FF_Boots_Pointy_AnkleLow", 0.1,
    "Base.FF_Boots_Pointy_Ankle", 0.1,
    "Base.FF_Boots_Pointy_Kneehigh", 0.1,
	"Base.FF_Boots_HF_New", 0.1,
	"Base.FF_Boots_HF_New_Longest", 0.1,
	"Base.FF_Boots_HF_New_Longer", 0.1,
	"Base.FF_Boots_HF_New_Long", 0.1,
	"Base.FF_Shoe_Boots_Ankle_Platform", 0.1,
	"Base.FF_Boots_HighHeels", 0.1,
	"Base.FF_Shoe_Women", 0.1,
	"Base.FF_Shoe_Women_Platform", 0.1,
	"Base.FF_Shoe_Women_2", 0.1,
	"Base.FF_Shoe_Moccasin", 0.1,
	"Base.FF_Boots_UGG_DwarfHeel", 0.1,
	"Base.FF_Boots_UGG_Heel", 0.1,
	"Base.FF_Boots_UGG_ThighhighHeel", 0.1,
	"Base.FF_Boots_UGG_KneehighHeel", 0.1,
	"Base.FF_Boots_UGG", 0.1,
	"Base.FF_Boots_UGG_Thighhigh", 0.1,
	"Base.FF_Boots_UGG_Kneehigh", 0.1,
	"Base.FF_Boots_Leather", 0.1,
	"Base.FF_Boots_Leather_Short", 0.1,
	"Base.FF_Boots_Cowboy", 0.1,
	"Base.FF_Boots_Cowboy_Plain", 0.1,
	"Base.FF_Shoe_Boots_Ankle", 0.1,
	"Base.FF_Shoe_Boots_Ankle_Steel", 0.1,
	"Base.FF_Boots_Common", 0.1,
	"Base.FF_Shoe_Common", 0.1,
	"Base.FF_Shoe_Trainers", 0.1,
	"Base.FF_Shoe_TrainersBlack", 0.1,
	"Base.FF_Shoe_TrainersWhite", 0.1,
	"Base.FF_Boots_Platform_Thighhigh", 0.1,
	"Base.FF_Boots_Platform_Kneehigher", 0.1,
	"Base.FF_Boots_Platform_Kneehigh", 0.1,
	"Base.FF_Boots_Platform_Ankle", 0.1,
	"Base.FF_Boots_Platform_AnkleLow", 0.1,
	"Base.FF_Boots_PlatformPunk_Thighhigh", 0.1,
	"Base.FF_Boots_PlatformPunk_Kneehigher", 0.1,
	"Base.FF_Boots_PlatformPunk_Kneehigh", 0.1,
	"Base.FF_Boots_Pointy_AnkleLow", 0.1,
	"Base.FF_Boots_Pointy_Ankle", 0.1,
	"Base.FF_Boots_Pointy_Kneehigh", 0.1,
	"Base.FF_Boots_PointySkull_AnkleLow", 0.1,
	"Base.FF_Boots_PointySkull_Kneehigh", 0.1,
	"Base.FF_BootsRE_Leather_DwarfHeel", 0.1,
	"Base.FF_BootsRE_Leather_Heel", 0.1,
	"Base.FF_BootsRE_Leather_ThighhighHeel", 0.1,
	"Base.FF_BootsRE_Leather_KneehighHeel", 0.1,
	"Base.FF_Boots_Military_Thighhigh", 0.1,
	"Base.FF_Boots_Military_Kneehigher", 0.1,
	"Base.FF_Boots_Military_Kneehigh", 0.1,
	"Base.FF_Boots_Military_Ankle", .5
)

BatchRuleInjection("SafehouseDryer",
    "Base.FF_Boots_HF_New", 2,
    "Base.FF_Boots_HF_New_Longest", 2,
    "Base.FF_Boots_HF_New_Longer", 2,
    "Base.FF_Boots_HF_New_Long", 2,
    "Base.FF_Boots_Leather", 2,
    "Base.FF_Boots_Leather_Short", 2,
    "Base.FF_Boots_Cowboy", 2,
    "Base.FF_Boots_Cowboy_Plain", 2,
    "Base.FF_Shoe_Boots_Ankle", 2,
    "Base.FF_Shoe_Boots_Ankle_Steel", 2,
    "Base.FF_Boots_Common", 2,
    "Base.FF_Boots_Platform_Thighhigh", 2,
    "Base.FF_Boots_Platform_Kneehigher", 2,
    "Base.FF_Boots_Platform_Kneehigh", 2,
    "Base.FF_Boots_Platform_Ankle", 2,
    "Base.FF_Boots_Platform_AnkleLow", 2,
    "Base.FF_Boots_Pointy_AnkleLow", 2,
    "Base.FF_Boots_Pointy_Ankle", 2,
    "Base.FF_Boots_Pointy_Kneehigh", 2,
	"Base.FF_Boots_HF_New", 2,
	"Base.FF_Boots_HF_New_Longest", 2,
	"Base.FF_Boots_HF_New_Longer", 2,
	"Base.FF_Boots_HF_New_Long", 2,
	"Base.FF_Shoe_Boots_Ankle_Platform", 2,
	"Base.FF_Boots_HighHeels", 2,
	"Base.FF_Shoe_Women", 2,
	"Base.FF_Shoe_Women_Platform", 2,
	"Base.FF_Shoe_Women_2", 2,
	"Base.FF_Shoe_Moccasin", 2,
	"Base.FF_Boots_UGG_DwarfHeel", 2,
	"Base.FF_Boots_UGG_Heel", 2,
	"Base.FF_Boots_UGG_ThighhighHeel", 2,
	"Base.FF_Boots_UGG_KneehighHeel", 2,
	"Base.FF_Boots_UGG", 2,
	"Base.FF_Boots_UGG_Thighhigh", 2,
	"Base.FF_Boots_UGG_Kneehigh", 2,
	"Base.FF_Boots_Leather", 2,
	"Base.FF_Boots_Leather_Short", 2,
	"Base.FF_Boots_Cowboy", 2,
	"Base.FF_Boots_Cowboy_Plain", 2,
	"Base.FF_Shoe_Boots_Ankle", 2,
	"Base.FF_Shoe_Boots_Ankle_Steel", 2,
	"Base.FF_Boots_Common", 2,
	"Base.FF_Shoe_Common", 2,
	"Base.FF_Shoe_Trainers", 2,
	"Base.FF_Shoe_TrainersBlack", 2,
	"Base.FF_Shoe_TrainersWhite", 2,
	"Base.FF_Boots_Platform_Thighhigh", 2,
	"Base.FF_Boots_Platform_Kneehigher", 2,
	"Base.FF_Boots_Platform_Kneehigh", 2,
	"Base.FF_Boots_Platform_Ankle", 2,
	"Base.FF_Boots_Platform_AnkleLow", 2,
	"Base.FF_Boots_PlatformPunk_Thighhigh", 2,
	"Base.FF_Boots_PlatformPunk_Kneehigher", 2,
	"Base.FF_Boots_PlatformPunk_Kneehigh", 2,
	"Base.FF_Boots_Pointy_AnkleLow", 2,
	"Base.FF_Boots_Pointy_Ankle", 2,
	"Base.FF_Boots_Pointy_Kneehigh", 2,
	"Base.FF_Boots_PointySkull_AnkleLow", 2,
	"Base.FF_Boots_PointySkull_Kneehigh", 2,
	"Base.FF_BootsRE_Leather_DwarfHeel", 2,
	"Base.FF_BootsRE_Leather_Heel", 2,
	"Base.FF_BootsRE_Leather_ThighhighHeel", 2,
	"Base.FF_BootsRE_Leather_KneehighHeel", 2,
	"Base.FF_Boots_Military_Thighhigh", 2,
	"Base.FF_Boots_Military_Kneehigher", 2,
	"Base.FF_Boots_Military_Kneehigh", 2,
	"Base.FF_Boots_Military_Ankle", 2
)

BatchRuleInjection("SafehouseArmor",
	"Base.Armour_PouchStrap", 2,
	"Base.Armour_Faulds", 2,
	"Base.Armour_Faulds_Short", 2,
	"Base.Armour_ShoulderPad_R", 2,
	"Base.Armour_ShoulderPad_L", 2,
	"Base.Armour_Armguards_R", 2,
	"Base.Armour_Armguards_L", 2,
	"Base.Armour_ArmguardsLong_R", 2,
	"Base.Armour_ArmguardsLong_L", 2,
	"Base.TannedLeather_SleevesLeg_L", 2,
	"Base.TannedLeather_SleevesLeg_R", 2,
	"Base.TannedLeather_Sleeves_L", 2,
	"Base.TannedLeather_Sleeves_R", 2,
	"Base.Hat_Cowboy_Flat", 2,
	"Base.TannedLeather_Long_Skirt", 2,
	"Base.TannedLeather_Skirt_Mid", 2,
	"Base.TannedLeather_Skirt_Short", 2,
	"Base.TannedLeather_Skirt_Shorter", 2,
	"Base.TannedLeather_Loincloth", 2
)

BatchRuleInjection("SafehouseArmor_Mid",
	"Base.Armour_PouchStrap", 2,
	"Base.Armour_Faulds", 2,
	"Base.Armour_Faulds_Short", 2,
	"Base.Armour_ShoulderPad_R", 2,
	"Base.Armour_ShoulderPad_L", 2,
	"Base.Armour_Armguards_R", 2,
	"Base.Armour_Armguards_L", 2,
	"Base.Armour_ArmguardsLong_R", 2,
	"Base.Armour_ArmguardsLong_L", 2,
	"Base.TannedLeather_SleevesLeg_L", 2,
	"Base.TannedLeather_SleevesLeg_R", 2,
	"Base.TannedLeather_Sleeves_L", 2,
	"Base.TannedLeather_Sleeves_R", 2,
	"Base.Hat_Cowboy_Flat", 2,
	"Base.TannedLeather_Long_Skirt", 2,
	"Base.TannedLeather_Skirt_Mid", 2,
	"Base.TannedLeather_Skirt_Short", 2,
	"Base.TannedLeather_Skirt_Shorter", 2,
	"Base.TannedLeather_Loincloth", 2
)

BatchRuleInjection("SafehouseArmor_Late",
	"Base.Armour_PouchStrap", 2,
	"Base.Armour_Faulds", 2,
	"Base.Armour_Faulds_Short", 2,
	"Base.Armour_ShoulderPad_R", 2,
	"Base.Armour_ShoulderPad_L", 2,
	"Base.Armour_Armguards_R", 2,
	"Base.Armour_Armguards_L", 2,
	"Base.Armour_ArmguardsLong_R", 2,
	"Base.Armour_ArmguardsLong_L", 2,
	"Base.TannedLeather_SleevesLeg_L", 2,
	"Base.TannedLeather_SleevesLeg_R", 2,
	"Base.TannedLeather_Sleeves_L", 2,
	"Base.TannedLeather_Sleeves_R", 2,
	"Base.Hat_Cowboy_Flat", 2,
	"Base.TannedLeather_Long_Skirt", 2,
	"Base.TannedLeather_Skirt_Mid", 2,
	"Base.TannedLeather_Skirt_Short", 2,
	"Base.TannedLeather_Skirt_Shorter", 2,
	"Base.TannedLeather_Loincloth", 2
)
    -- Add more containers as needed...

